/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package nl.surfnet.coin.teams.service.impl;

import nl.surfnet.coin.api.client.domain.Group20Entry;
import nl.surfnet.coin.api.client.domain.GroupMembersEntry;

/**
 * Interface to Grouper
 * 
 */
public interface ApiGrouperDao {

  Group20Entry findGroup20(String personId, String groupName);

  Group20Entry findAllGroup20sByMember(String personId, Integer offset, Integer pageSize, String sortBy);

  GroupMembersEntry findAllMembers(String groupId, Integer offset, Integer pageSize);

  Group20Entry findGroups20ByIds(String personId, String[] groupIds, Integer pageSize, Integer offset);
}