/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import nl.surfnet.coin.teams.domain.ExternalGroup;
import nl.surfnet.coin.teams.domain.TeamExternalGroup;
import nl.surfnet.coin.teams.service.TeamExternalGroupDao;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="teamExternalGroupDao")
public class TeamExternalGroupDaoImpl
implements TeamExternalGroupDao {
    private static final String IDENTIFIER = "identifier";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String GROUP_PROVIDER = "group_provider";
    private static final String GROUPER_TEAM_ID = "grouper_team_id";
    @Resource(name="grouperJdbcTemplate")
    private JdbcTemplate jdbcTemplate;

    public void setJdbcTemplate(JdbcTemplate tpl) {
        this.jdbcTemplate = tpl;
    }

    @Override
    public ExternalGroup getExternalGroupByIdentifier(String identifier) {
        Object[] args = new Object[]{identifier};
        try {
            return (ExternalGroup)((Object)this.jdbcTemplate.queryForObject("SELECT * FROM external_groups AS eg WHERE eg.identifier = ?", args, (RowMapper)new RowMapper<ExternalGroup>(){

                public ExternalGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
                    ExternalGroup e = new ExternalGroup();
                    e.setId(rs.getLong("id"));
                    e.setIdentifier(rs.getString(TeamExternalGroupDaoImpl.IDENTIFIER));
                    e.setDescription(rs.getString(TeamExternalGroupDaoImpl.DESCRIPTION));
                    e.setName(rs.getString(TeamExternalGroupDaoImpl.NAME));
                    e.setGroupProviderIdentifier(rs.getString(TeamExternalGroupDaoImpl.GROUP_PROVIDER));
                    return e;
                }
            }));
        }
        catch (EmptyResultDataAccessException er) {
            return null;
        }
    }

    @Override
    public List<TeamExternalGroup> getByTeamIdentifier(String identifier) {
        Object[] args = new Object[]{identifier};
        try {
            String s = "SELECT teg.id AS teg_id, teg.grouper_team_id, eg.id AS eg_id, eg.identifier, eg.name, eg.description, eg.group_provider           FROM team_external_groups AS teg           INNER JOIN external_groups AS eg           ON teg.external_groups_id = eg.id           WHERE teg.grouper_team_id = ? ";
            return this.jdbcTemplate.query(s, args, (RowMapper)new RowMapper<TeamExternalGroup>(){

                public TeamExternalGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return TeamExternalGroupDaoImpl.this.mapRowToTeamExternalGroup(rs);
                }
            });
        }
        catch (EmptyResultDataAccessException er) {
            return null;
        }
    }

    @Override
    public List<TeamExternalGroup> getByExternalGroupIdentifier(String identifier) {
        Object[] args = new Object[]{identifier};
        try {
            String s = "SELECT teg.id AS teg_id, teg.grouper_team_id, eg.id AS eg_id, eg.identifier, eg.name, eg.description, eg.group_provider           FROM team_external_groups AS teg           INNER JOIN external_groups AS eg           ON teg.external_groups_id = eg.id           WHERE eg.identifier = ? ";
            return this.jdbcTemplate.query(s, args, (RowMapper)new RowMapper<TeamExternalGroup>(){

                public TeamExternalGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return TeamExternalGroupDaoImpl.this.mapRowToTeamExternalGroup(rs);
                }
            });
        }
        catch (EmptyResultDataAccessException er) {
            return new ArrayList<TeamExternalGroup>();
        }
    }

    @Override
    public TeamExternalGroup getByTeamIdentifierAndExternalGroupIdentifier(String teamId, String externalGroupIdentifier) {
        Object[] args = new Object[]{teamId, externalGroupIdentifier};
        String s = "SELECT teg.id AS teg_id, teg.grouper_team_id, eg.id AS eg_id, eg.identifier, eg.name, eg.description, eg.group_provider           FROM team_external_groups AS teg           INNER JOIN external_groups AS eg           ON teg.external_groups_id = eg.id           WHERE teg.grouper_team_id = ? AND eg.identifier = ?";
        try {
            return (TeamExternalGroup)((Object)this.jdbcTemplate.queryForObject(s, args, (RowMapper)new RowMapper<TeamExternalGroup>(){

                public TeamExternalGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return TeamExternalGroupDaoImpl.this.mapRowToTeamExternalGroup(rs);
                }
            }));
        }
        catch (EmptyResultDataAccessException er) {
            return null;
        }
    }

    private TeamExternalGroup mapRowToTeamExternalGroup(ResultSet rs) throws SQLException {
        ExternalGroup e = new ExternalGroup();
        e.setId(rs.getLong("eg_id"));
        e.setIdentifier(rs.getString(IDENTIFIER));
        e.setDescription(rs.getString(DESCRIPTION));
        e.setName(rs.getString(NAME));
        e.setGroupProviderIdentifier(rs.getString(GROUP_PROVIDER));
        TeamExternalGroup teg = new TeamExternalGroup();
        teg.setId(rs.getLong("teg_id"));
        teg.setGrouperTeamId(rs.getString(GROUPER_TEAM_ID));
        teg.setExternalGroup(e);
        return teg;
    }

    @Override
    public void saveOrUpdate(TeamExternalGroup teamExternalGroup) {
        TeamExternalGroup storedTeg = this.getByTeamIdentifierAndExternalGroupIdentifier(teamExternalGroup.getGrouperTeamId(), teamExternalGroup.getExternalGroup().getIdentifier());
        if (storedTeg != null) {
            this.updateExternalGroupValues(storedTeg.getExternalGroup(), teamExternalGroup.getExternalGroup());
            return;
        }
        ExternalGroup storedEg = this.getExternalGroupByIdentifier(teamExternalGroup.getExternalGroup().getIdentifier());
        if (storedEg == null) {
            this.insertExternalGroup(teamExternalGroup.getExternalGroup());
        } else {
            this.updateExternalGroupValues(storedEg, teamExternalGroup.getExternalGroup());
        }
        storedEg = this.getExternalGroupByIdentifier(teamExternalGroup.getExternalGroup().getIdentifier());
        teamExternalGroup.setExternalGroup(storedEg);
        Object[] args = new Object[]{teamExternalGroup.getGrouperTeamId(), teamExternalGroup.getExternalGroup().getId()};
        String s = "INSERT INTO team_external_groups(grouper_team_id, external_groups_id) VALUES (?, ?);";
        this.jdbcTemplate.update(s, args);
    }

    private void insertExternalGroup(ExternalGroup externalGroup) {
        Object[] args = new Object[]{externalGroup.getDescription(), externalGroup.getGroupProviderIdentifier(), externalGroup.getIdentifier(), externalGroup.getName()};
        String s = "INSERT INTO external_groups (description, group_provider, identifier, name) VALUES (?, ?, ?, ?);";
        this.jdbcTemplate.update(s, args);
    }

    private void updateExternalGroupValues(ExternalGroup existing, ExternalGroup newEG) {
        Object[] newVals = new Object[]{newEG.getName(), newEG.getDescription(), existing.getId()};
        this.jdbcTemplate.update("UPDATE external_groups SET name = ?, description = ? WHERE id = ?", newVals);
    }

    @Override
    public void delete(TeamExternalGroup teamExternalGroup) {
        Object[] args = new Object[]{teamExternalGroup.getId()};
        int deleted = this.jdbcTemplate.update("DELETE FROM team_external_groups WHERE id = ?;", args);
        if (deleted == 0) {
            return;
        }
        args[0] = teamExternalGroup.getExternalGroup().getId();
        int linksToExternalGroup = this.jdbcTemplate.queryForInt("SELECT COUNT(id) FROM team_external_groups WHERE external_groups_id = ?;", args);
        if (linksToExternalGroup == 0) {
            this.jdbcTemplate.update("DELETE FROM external_groups WHERE id = ?;", args);
        }
    }

    @Override
    public List<TeamExternalGroup> getByExternalGroupIdentifiers(Collection<String> identifiers) {
        try {
            NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
            HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
            params.put("identifiers", identifiers);
            String s = "SELECT teg.id AS teg_id, teg.grouper_team_id, eg.id AS eg_id, eg.identifier, eg.name, eg.description, eg.group_provider FROM team_external_groups AS teg INNER JOIN external_groups AS eg ON teg.external_groups_id = eg.id WHERE eg.identifier in (:identifiers) ";
            return template.query(s, params, (RowMapper)new RowMapper<TeamExternalGroup>(){

                public TeamExternalGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return TeamExternalGroupDaoImpl.this.mapRowToTeamExternalGroup(rs);
                }
            });
        }
        catch (EmptyResultDataAccessException er) {
            return new ArrayList<TeamExternalGroup>();
        }
    }
}

