/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Group20Entry;
import nl.surfnet.coin.api.client.domain.GroupMembersEntry;
import nl.surfnet.coin.teams.domain.GroupProvider;
import nl.surfnet.coin.teams.service.BasicAuthGroupService;
import nl.surfnet.coin.teams.service.impl.AbstractGroupService;
import nl.surfnet.coin.teams.util.GroupProviderPropertyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="basicAuthGroupService")
public class GroupServiceBasicAuthentication
extends AbstractGroupService
implements BasicAuthGroupService {
    private static final Logger LOG = LoggerFactory.getLogger(GroupServiceBasicAuthentication.class);
    private Client client = Client.create();

    @Override
    public Group20Entry getGroup20Entry(GroupProvider groupProvider, String personId, int limit, int offset) {
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(personId, groupProvider);
        Client client = this.getClient(groupProvider);
        String url = String.format("%s/groups/%s?startIndex=%s&count=%s", groupProvider.getAllowedOptionAsString("url"), strippedPersonID, offset, limit);
        LOG.info("Getting groups for person {} at groupProvider {}, using URL: {}", new Object[]{personId, groupProvider.getIdentifier(), url});
        WebResource webResource = client.resource(url);
        Group20Entry entry = this.getGroup20Entry(groupProvider, webResource);
        LOG.debug("Got group information: {}", (Object)entry);
        return entry;
    }

    @Override
    public Group20 getGroup20(GroupProvider groupProvider, String personId, String groupId) {
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(personId, groupProvider);
        String strippedGroupID = GroupProviderPropertyConverter.convertToExternalGroupId(groupId, groupProvider);
        Client client = this.getClient(groupProvider);
        String url = String.format("%s/groups/%s/%s", groupProvider.getAllowedOptionAsString("url"), strippedPersonID, strippedGroupID);
        LOG.info("Getting group information for person {} and group {} at groupProvider {}, using URL: {}", new Object[]{personId, groupId, groupProvider.getIdentifier(), url});
        WebResource webResource = client.resource(url);
        Group20Entry entry = this.getGroup20Entry(groupProvider, webResource);
        LOG.debug("Got group information: {}", (Object)entry);
        if (entry == null || entry.getEntry() == null || entry.getEntry().isEmpty()) {
            return null;
        }
        List group20s = entry.getEntry();
        if (group20s != null && group20s.size() == 1) {
            return (Group20)group20s.get(0);
        }
        throw new RuntimeException(String.format("Received %s groups for groupid %s", group20s.size(), groupId));
    }

    private Group20Entry getGroup20Entry(GroupProvider groupProvider, WebResource webResource) {
        Group20Entry entry = null;
        try {
            InputStream response = (InputStream)webResource.get(InputStream.class);
            entry = this.getGroup20EntryFromResponse(response, groupProvider);
        }
        catch (UniformInterfaceException e) {
            log.error("Received error from " + groupProvider, (Throwable)e);
        }
        return entry;
    }

    @Override
    public GroupMembersEntry getGroupMembersEntry(GroupProvider groupProvider, String personId, String groupId, int limit, int offset) {
        String response;
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(personId, groupProvider);
        String strippedGroupId = GroupProviderPropertyConverter.convertToExternalGroupId(groupId, groupProvider);
        Client client = this.getClient(groupProvider);
        String url = String.format("%s/people/%s/%s?startIndex=%s&count=%s&sortBy=name.familyName", groupProvider.getAllowedOptionAsString("url"), strippedPersonID, strippedGroupId, offset, limit);
        LOG.info("Getting group members for person {} and group {} at groupProvider {}, using URL: {}", new Object[]{personId, groupId, groupProvider.getIdentifier(), url});
        WebResource webResource = client.resource(url);
        try {
            response = (String)webResource.get(String.class);
        }
        catch (UniformInterfaceException e) {
            log.error("Received error from " + groupProvider, (Throwable)e);
            return new GroupMembersEntry(new ArrayList());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(response.getBytes());
        GroupMembersEntry entry = this.getGroupMembersEntryFromResponse(in, groupProvider);
        LOG.debug("Got member information: {}", (Object)entry);
        return entry;
    }

    private Client getClient(GroupProvider groupProvider) {
        String user = groupProvider.getAllowedOptionAsString("user");
        String password = groupProvider.getAllowedOptionAsString("password");
        this.client.removeAllFilters();
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, password));
        return this.client;
    }
}

