/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.surfnet.coin.teams.domain.ConversionRule;
import nl.surfnet.coin.teams.domain.GroupProvider;
import nl.surfnet.coin.teams.domain.GroupProviderPreconditionTypes;
import nl.surfnet.coin.teams.domain.GroupProviderUserOauth;
import nl.surfnet.coin.teams.domain.ServiceProviderGroupAcl;
import nl.surfnet.coin.teams.service.GroupProviderService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class GroupProviderServiceSQLImpl
implements GroupProviderService {
    private static final String SELECT_USER_OAUTH = "SELECT gp_user_oauth.user_id, gp_user_oauth.provider_id, gp_user_oauth.oauth_token, gp_user_oauth.oauth_secret FROM group_provider_user_oauth as gp_user_oauth WHERE gp_user_oauth.user_id = ?";
    private static final String SELECT_GROUP_PROVIDER_BY_IDENTIFIER = "SELECT gp.id, gp.identifier, gp.name, gp.classname, gp.logo_url FROM group_provider AS gp WHERE gp.identifier ";
    private static final String SELECT_ALL_GROUP_PROVIDER = "SELECT gp.id, gp.identifier, gp.name, gp.classname, gp.logo_url FROM group_provider AS gp ";
    private final JdbcTemplate jdbcTemplate;

    public GroupProviderServiceSQLImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public List<GroupProviderUserOauth> getGroupProviderUserOauths(String userId) {
        List<GroupProviderUserOauth> gpUserOauths;
        try {
            GroupProviderUserOauthRowMapper rowMapper = new GroupProviderUserOauthRowMapper();
            gpUserOauths = this.jdbcTemplate.query(SELECT_USER_OAUTH, new Object[]{userId}, (RowMapper)rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            gpUserOauths = new ArrayList<GroupProviderUserOauth>();
        }
        return gpUserOauths;
    }

    @Override
    public GroupProviderUserOauth getGroupProviderUserOauth(String userId, String groupProviderIdentifier) {
        GroupProviderUserOauth gpUserOauth = null;
        try {
            GroupProviderUserOauthRowMapper rowMapper = new GroupProviderUserOauthRowMapper();
            gpUserOauth = (GroupProviderUserOauth)this.jdbcTemplate.queryForObject("SELECT gp_user_oauth.user_id, gp_user_oauth.provider_id, gp_user_oauth.oauth_token, gp_user_oauth.oauth_secret FROM group_provider_user_oauth as gp_user_oauth WHERE gp_user_oauth.user_id = ? and gp_user_oauth.provider_id = ?", new Object[]{userId, groupProviderIdentifier}, (RowMapper)rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            // empty catch block
        }
        return gpUserOauth;
    }

    @Override
    public GroupProvider getGroupProviderByStringIdentifier(String identifier) {
        Object[] args = new Object[]{identifier};
        try {
            return (GroupProvider)this.jdbcTemplate.queryForObject("SELECT gp.id, gp.identifier, gp.name, gp.classname, gp.logo_url FROM group_provider AS gp WHERE gp.identifier =?", args, (RowMapper)new RowMapper<GroupProvider>(){

                public GroupProvider mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GroupProviderServiceSQLImpl.this.mapRowToGroupProvider(rs);
                }
            });
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private GroupProvider mapRowToGroupProvider(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String identifier = rs.getString("identifier");
        String name = rs.getString("name");
        String gpClassName = rs.getString("classname");
        GroupProvider gp = new GroupProvider(id, identifier, name, gpClassName);
        String logoUrl = rs.getString("logo_url");
        gp.setLogoUrl(logoUrl);
        gp.setAllowedOptions(this.getAllowedOptions(gp));
        gp.setUserIdPrecondition(this.getUserIdPreCondition(id));
        gp.setPersonDecorators(this.getPersonIdDecorators(gp));
        gp.setGroupDecorators(this.getGroupIdDecorators(gp));
        gp.setPersonFilters(this.getPersonIdFilters(gp));
        gp.setGroupFilters(this.getGroupIdFilters(gp));
        gp.setServiceProviderGroupAcls(this.getServiceProviderGroupAcl(gp));
        return gp;
    }

    private String getUserIdPreCondition(Long id) {
        Object[] args = new Object[]{id, GroupProviderPreconditionTypes.USER_ID_REGEX.getStringValue()};
        try {
            return (String)this.jdbcTemplate.queryForObject("SELECT gppo.value FROM group_provider_precondition gpp LEFT JOIN group_provider_precondition_option gppo ON gpp.id = gppo.group_provider_precondition_id WHERE gpp.group_provider_id = ? AND gpp.className = ?;", args, (RowMapper)new RowMapper<String>(){

                public String mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("value");
                }
            });
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<GroupProvider> getOAuthGroupProviders(String userId) {
        List<GroupProvider> groupProviders;
        Object[] args = new Object[]{userId};
        try {
            groupProviders = this.jdbcTemplate.query("SELECT gp.id, gp.identifier, gp.name, gp.classname, gp.logo_url FROM group_provider AS gp WHERE gp.identifier  IN (SELECT gp_user_oauth.provider_id      FROM group_provider_user_oauth as gp_user_oauth      WHERE gp_user_oauth.user_id = ?);", args, (RowMapper)new RowMapper<GroupProvider>(){

                public GroupProvider mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GroupProviderServiceSQLImpl.this.mapRowToGroupProvider(rs);
                }
            });
        }
        catch (EmptyResultDataAccessException e) {
            groupProviders = new ArrayList<GroupProvider>();
        }
        return groupProviders;
    }

    private Map<String, Object> getAllowedOptions(GroupProvider groupProvider) {
        Object[] args = new Object[]{groupProvider.getId()};
        HashMap<String, Object> options = new HashMap<String, Object>();
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("SELECT gp_option.name, gp_option.value FROM group_provider_option AS gp_option WHERE gp_option.group_provider_id = ?;", args);
        while (sqlRowSet.next()) {
            options.put(sqlRowSet.getString("name"), sqlRowSet.getObject("value"));
        }
        return options;
    }

    private List<ConversionRule> getPersonIdDecorators(GroupProvider groupProvider) {
        return this.getDecorators(groupProvider, "EngineBlock_Group_Provider_Decorator_UserIdReplace");
    }

    private List<ConversionRule> getGroupIdDecorators(GroupProvider groupProvider) {
        return this.getDecorators(groupProvider, "EngineBlock_Group_Provider_Decorator_GroupIdReplace");
    }

    private List<ConversionRule> getDecorators(GroupProvider groupProvider, String providerClassName) {
        Object[] args = new Object[]{groupProvider.getId(), providerClassName};
        try {
            SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("SELECT gpd.id, gpdo.name, gpdo.value  FROM group_provider_decorator gpd LEFT JOIN group_provider_decorator_option gpdo ON gpd.id = gpdo.group_provider_decorator_id WHERE gpd.group_provider_id = ? AND gpd.classname = ? ORDER BY gpd.id;", args);
            return this.getIdConverters(sqlRowSet);
        }
        catch (EmptyResultDataAccessException e) {
            return new ArrayList<ConversionRule>();
        }
    }

    private List<ConversionRule> getPersonIdFilters(GroupProvider groupProvider) {
        return this.getFilters(groupProvider, "groupMember");
    }

    private List<ConversionRule> getGroupIdFilters(GroupProvider groupProvider) {
        return this.getFilters(groupProvider, "group");
    }

    private List<ConversionRule> getFilters(GroupProvider groupProvider, String filterType) {
        Object[] args = new Object[]{groupProvider.getId(), filterType};
        try {
            SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("SELECT gpf.id, gpf.type, gpf.classname, gpfo.name, gpfo.value  FROM group_provider_filter gpf LEFT JOIN group_provider_filter_option gpfo ON gpf.id = gpfo.group_provider_filter_id WHERE gpf.group_provider_id = ? AND gpf.type = ? ORDER BY gpf.id;", args);
            return this.getIdConverters(sqlRowSet);
        }
        catch (EmptyResultDataAccessException e) {
            return new ArrayList<ConversionRule>();
        }
    }

    private List<ConversionRule> getIdConverters(SqlRowSet sqlRowSet) {
        HashMap<Integer, ConversionRule> idConverterMap = new HashMap<Integer, ConversionRule>();
        String id = "id";
        String nameCol = "name";
        String valueCol = "value";
        String name_search = "search";
        String name_replace = "replace";
        String name_property = "property";
        while (sqlRowSet.next()) {
            ConversionRule converter;
            Integer ruleId = sqlRowSet.getInt("id");
            if (idConverterMap.containsKey(ruleId)) {
                converter = (ConversionRule)idConverterMap.get(ruleId);
            } else {
                converter = new ConversionRule();
                converter.setPropertyName("id");
            }
            String name = sqlRowSet.getString("name");
            String value = sqlRowSet.getString("value");
            if ("search".equals(name)) {
                converter.setSearchPattern(value);
            }
            if ("replace".equals(name)) {
                converter.setReplaceWith(value);
            }
            if ("property".equals(name)) {
                converter.setPropertyName(value);
            }
            idConverterMap.put(ruleId, converter);
        }
        return new ArrayList<ConversionRule>(idConverterMap.values());
    }

    private List<ServiceProviderGroupAcl> getServiceProviderGroupAcl(GroupProvider groupProvider) {
        List<ServiceProviderGroupAcl> spGroupAcls;
        try {
            ServiceProviderGroupAclRowMapper rowMapper = new ServiceProviderGroupAclRowMapper();
            spGroupAcls = this.jdbcTemplate.query("SELECT  group_provider_id, spentityid, allow_groups, allow_members FROM service_provider_group_acl WHERE group_provider_id = ?", new Object[]{groupProvider.getId()}, (RowMapper)rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            spGroupAcls = new ArrayList<ServiceProviderGroupAcl>();
        }
        return spGroupAcls;
    }

    protected void execute(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public List<GroupProvider> getAllGroupProviders() {
        try {
            return this.jdbcTemplate.query(SELECT_ALL_GROUP_PROVIDER, (RowMapper)new RowMapper<GroupProvider>(){

                public GroupProvider mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GroupProviderServiceSQLImpl.this.mapRowToGroupProvider(rs);
                }
            });
        }
        catch (EmptyResultDataAccessException e) {
            return new ArrayList<GroupProvider>();
        }
    }

    private class GroupProviderUserOauthRowMapper
    implements RowMapper<GroupProviderUserOauth> {
        private GroupProviderUserOauthRowMapper() {
        }

        public GroupProviderUserOauth mapRow(ResultSet rs, int rowNum) throws SQLException {
            String userId = rs.getString("user_id");
            String providerId = rs.getString("provider_id");
            String token = rs.getString("oauth_token");
            String secret = rs.getString("oauth_secret");
            return new GroupProviderUserOauth(userId, providerId, token, secret);
        }
    }

    private class ServiceProviderGroupAclRowMapper
    implements RowMapper<ServiceProviderGroupAcl> {
        private ServiceProviderGroupAclRowMapper() {
        }

        public ServiceProviderGroupAcl mapRow(ResultSet rs, int rowNum) throws SQLException {
            long providerId = rs.getLong("group_provider_id");
            String serviceProviderEntityId = rs.getString("spentityid");
            boolean allowGroups = rs.getBoolean("allow_groups");
            boolean allowMembers = rs.getBoolean("allow_members");
            return new ServiceProviderGroupAcl(allowGroups, allowMembers, serviceProviderEntityId, providerId);
        }
    }
}

