/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Group20Entry;
import nl.surfnet.coin.api.client.domain.GroupMembersEntry;
import nl.surfnet.coin.api.client.domain.Person;
import nl.surfnet.coin.teams.domain.GroupProvider;
import nl.surfnet.coin.teams.domain.GroupProviderUserOauth;
import nl.surfnet.coin.teams.domain.ThreeLeggedOauth10aGroupProviderApi;
import nl.surfnet.coin.teams.service.OauthGroupService;
import nl.surfnet.coin.teams.service.impl.AbstractGroupService;
import nl.surfnet.coin.teams.service.impl.GroupProviderServiceThreeLeggedOAuth10a;
import nl.surfnet.coin.teams.util.GroupProviderPropertyConverter;
import org.scribe.builder.api.Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="oauthGroupService")
public class GroupServiceThreeLeggedOAuth10a
extends AbstractGroupService
implements OauthGroupService {
    private static Logger log = LoggerFactory.getLogger(GroupServiceThreeLeggedOAuth10a.class);
    private static final int MAX_ITEMS = 1000;

    @Override
    public Group20Entry getGroup20Entry(GroupProviderUserOauth oauth, GroupProvider groupProvider, int limit, int offset) {
        ThreeLeggedOauth10aGroupProviderApi api = new ThreeLeggedOauth10aGroupProviderApi(groupProvider);
        GroupProviderServiceThreeLeggedOAuth10a tls = new GroupProviderServiceThreeLeggedOAuth10a(groupProvider, (Api)api);
        OAuthService oAuthService = tls.getOAuthService();
        Token accessToken = new Token(oauth.getOAuthToken(), oauth.getOAuthSecret());
        String strippedID = GroupProviderPropertyConverter.convertToExternalPersonId(oauth.getPersonId(), groupProvider);
        OAuthRequest oAuthRequest = this.getGroupListOAuthRequest(groupProvider, api, strippedID);
        oAuthRequest.addQuerystringParameter("startIndex", Integer.toString(offset));
        oAuthRequest.addQuerystringParameter("count", Integer.toString(limit));
        oAuthService.signRequest(accessToken, oAuthRequest);
        log.info("About to get group information with group provider {} using URL: {}", (Object)groupProvider.getIdentifier(), (Object)oAuthRequest);
        Response oAuthResponse = oAuthRequest.send();
        if (oAuthResponse.isSuccessful()) {
            Group20Entry entry = this.getGroup20EntryFromResponse(oAuthResponse.getStream(), groupProvider);
            log.debug("Got group entry: {}", (Object)entry);
            return entry;
        }
        log.warn("Fetching external groups for GroupProvider {} for user {} failed with status code {}", new Object[]{groupProvider, oauth.getPersonId(), oAuthResponse.getCode()});
        log.warn(oAuthResponse.getBody());
        return null;
    }

    @Override
    public List<Group20> getGroup20List(GroupProviderUserOauth oauth, GroupProvider provider) {
        Group20Entry group20Entry = this.getGroup20Entry(oauth, provider, 1000, 0);
        return group20Entry == null ? new ArrayList() : group20Entry.getEntry();
    }

    @Override
    public Group20 getGroup20(GroupProviderUserOauth oauth, GroupProvider groupProvider, String groupId) {
        ThreeLeggedOauth10aGroupProviderApi api = new ThreeLeggedOauth10aGroupProviderApi(groupProvider);
        GroupProviderServiceThreeLeggedOAuth10a tls = new GroupProviderServiceThreeLeggedOAuth10a(groupProvider, (Api)api);
        OAuthService oAuthService = tls.getOAuthService();
        Token accessToken = new Token(oauth.getOAuthToken(), oauth.getOAuthSecret());
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(oauth.getPersonId(), groupProvider);
        String strippedGroupID = GroupProviderPropertyConverter.convertToExternalGroupId(groupId, groupProvider);
        OAuthRequest oAuthRequest = this.getGroupOAuthRequest(groupProvider, api, strippedPersonID, strippedGroupID);
        oAuthService.signRequest(accessToken, oAuthRequest);
        log.info("About to get group information with group provider {} for group {} using URL: {}", new Object[]{groupProvider.getIdentifier(), groupId, oAuthRequest});
        Response oAuthResponse = oAuthRequest.send();
        if (oAuthResponse.isSuccessful()) {
            Group20Entry group20Entry = this.getGroup20EntryFromResponse(oAuthResponse.getStream(), groupProvider);
            log.debug("Got group entry: {}", (Object)group20Entry);
            if (group20Entry == null) {
                return null;
            }
            List group20s = group20Entry.getEntry();
            if (group20s != null && group20s.size() == 1) {
                return (Group20)group20s.get(0);
            }
            if (group20s != null && group20s.size() > 1) {
                throw new RuntimeException(String.format("Received %s groups for groupid %s", group20s.size(), groupId));
            }
        } else {
            log.info("Fetching external group {} for user {} failed with status code {}", new Object[]{groupId, oauth.getPersonId(), oAuthResponse.getCode()});
            log.trace(oAuthResponse.getBody());
        }
        return null;
    }

    @Override
    public List<Person> getGroupMembers(GroupProviderUserOauth oauth, GroupProvider provider, String groupId) {
        GroupMembersEntry groupMembers = this.getGroupMembersEntry(oauth, provider, groupId, 1000, 0);
        return groupMembers == null ? new ArrayList() : groupMembers.getEntry();
    }

    @Override
    public GroupMembersEntry getGroupMembersEntry(GroupProviderUserOauth oauth, GroupProvider provider, String groupId, int limit, int offset) {
        ThreeLeggedOauth10aGroupProviderApi api = new ThreeLeggedOauth10aGroupProviderApi(provider);
        GroupProviderServiceThreeLeggedOAuth10a tls = new GroupProviderServiceThreeLeggedOAuth10a(provider, (Api)api);
        OAuthService oAuthService = tls.getOAuthService();
        Token accessToken = new Token(oauth.getOAuthToken(), oauth.getOAuthSecret());
        String strippedPersonID = GroupProviderPropertyConverter.convertToExternalPersonId(oauth.getPersonId(), provider);
        String strippedGroupId = GroupProviderPropertyConverter.convertToExternalGroupId(groupId, provider);
        OAuthRequest oAuthRequest = this.getGroupMembersOAuthRequest(provider, api, strippedPersonID, strippedGroupId);
        oAuthRequest.addQuerystringParameter("count", String.valueOf(limit));
        oAuthRequest.addQuerystringParameter("startIndex", String.valueOf(offset));
        oAuthRequest.addQuerystringParameter("sortBy", "familyName");
        oAuthService.signRequest(accessToken, oAuthRequest);
        log.info("About to get group members for group {} with group provider {} using URL: {}", new Object[]{groupId, provider.getIdentifier(), oAuthRequest});
        Response oAuthResponse = oAuthRequest.send();
        if (oAuthResponse.isSuccessful()) {
            GroupMembersEntry entry = this.getGroupMembersEntryFromResponse(oAuthResponse.getStream(), provider);
            log.debug("Got GroupMembersEntry: {}", (Object)entry);
            return entry;
        }
        log.info("Fetching external groupmembers for user {} for group {} failed with status code {}", new Object[]{strippedPersonID, strippedPersonID, oAuthResponse.getCode()});
        log.trace(oAuthResponse.getBody());
        return null;
    }

    private OAuthRequest getGroupListOAuthRequest(GroupProvider provider, ThreeLeggedOauth10aGroupProviderApi api, String strippedPersonID) {
        OAuthRequest oAuthRequest = new OAuthRequest(api.getRequestTokenVerb(), MessageFormat.format("{0}/groups/{1}", provider.getAllowedOptionAsString("url"), strippedPersonID));
        return oAuthRequest;
    }

    private OAuthRequest getGroupOAuthRequest(GroupProvider provider, ThreeLeggedOauth10aGroupProviderApi api, String strippedPersonID, String strippedGroupId) {
        OAuthRequest oAuthRequest = new OAuthRequest(api.getRequestTokenVerb(), MessageFormat.format("{0}/groups/{1}/{2}", provider.getAllowedOptionAsString("url"), strippedPersonID, strippedGroupId));
        return oAuthRequest;
    }

    private OAuthRequest getGroupMembersOAuthRequest(GroupProvider provider, ThreeLeggedOauth10aGroupProviderApi api, String strippedPersonID, String strippedGroupId) {
        OAuthRequest oAuthRequest = new OAuthRequest(api.getRequestTokenVerb(), MessageFormat.format("{0}/people/{1}/{2}", provider.getAllowedOptionAsString("url"), strippedPersonID, strippedGroupId));
        return oAuthRequest;
    }
}

