/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.util;

import java.util.List;
import nl.surfnet.coin.teams.domain.ConversionRule;
import nl.surfnet.coin.teams.domain.GroupProvider;

public class GroupProviderPropertyConverter {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DESCRIPTION = "description";
    private static final String GROUP_URN_PREFIX = "urn:collab:group";

    public static boolean isGroupFromGroupProvider(String groupId, GroupProvider groupProvider) {
        return !GroupProviderPropertyConverter.convertToExternalGroupId(groupId, groupProvider).startsWith(GROUP_URN_PREFIX);
    }

    public static String convertToExternalPersonId(String input, GroupProvider groupProvider) {
        List<ConversionRule> converters = groupProvider.getPersonDecorators();
        return GroupProviderPropertyConverter.convertProperty(PROPERTY_ID, input, converters);
    }

    public static String convertToSurfConextPersonId(String input, GroupProvider groupProvider) {
        List<ConversionRule> converters = groupProvider.getPersonFilters();
        return GroupProviderPropertyConverter.convertProperty(PROPERTY_ID, input, converters);
    }

    public static String convertToExternalGroupId(String input, GroupProvider groupProvider) {
        List<ConversionRule> converters = groupProvider.getGroupDecorators();
        return GroupProviderPropertyConverter.convertProperty(PROPERTY_ID, input, converters);
    }

    public static String convertToSurfConextGroupId(String input, GroupProvider groupProvider) {
        List<ConversionRule> converters = groupProvider.getGroupFilters();
        return GroupProviderPropertyConverter.convertProperty(PROPERTY_ID, input, converters);
    }

    public static String convertProperty(String propertyName, String propertyValue, List<ConversionRule> converters) {
        String s = propertyValue;
        for (ConversionRule converter : converters) {
            if (s == null || !propertyName.equals(converter.getPropertyName())) continue;
            s = s.replaceAll(converter.getSearchPattern(), converter.getReplaceWith());
        }
        return s;
    }
}

