/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.janus.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.surfnet.coin.janus.Janus;
import nl.surfnet.coin.janus.domain.Contact;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class EntityMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String oauthConsumerKey;
    private String oauthConsumerSecret;
    private String appTitle;
    private String appIcon;
    private String appDescription;
    private String appThumbNail;
    private String appEntityId;
    private String oauthCallbackUrl;
    private boolean twoLeggedOauthAllowed;
    private boolean consentNotRequired;
    private String appLogoUrl;
    private String appHomeUrl;
    private String eula;
    private String description;
    private boolean isIdpVisibleOnly;
    private String workflowState;
    private List<Contact> contacts = Collections.synchronizedList(new ArrayList());

    public static EntityMetadata fromMetadataMap(Map<String, Object> metadata) {
        EntityMetadata em = new EntityMetadata();
        em.setName((String)metadata.get(Janus.Metadata.NAME.val()));
        em.setDescription((String)metadata.get(Janus.Metadata.DESCRIPTION.val()));
        em.setOauthConsumerSecret((String)metadata.get(Janus.Metadata.OAUTH_SECRET.val()));
        em.setOauthConsumerKey((String)metadata.get(Janus.Metadata.OAUTH_CONSUMERKEY.val()));
        em.setAppDescription((String)metadata.get(Janus.Metadata.OAUTH_APPDESCRIPTION.val()));
        em.setAppIcon((String)metadata.get(Janus.Metadata.OAUTH_APPICON.val()));
        em.setAppThumbNail((String)metadata.get(Janus.Metadata.OAUTH_APPTHUMBNAIL.val()));
        em.setAppTitle((String)metadata.get(Janus.Metadata.OAUTH_APPTITLE.val()));
        em.setOauthCallbackUrl((String)metadata.get(Janus.Metadata.OAUTH_CALLBACKURL.val()));
        em.setAppHomeUrl((String)metadata.get(Janus.Metadata.ORGANIZATION_URL.val()));
        em.setAppLogoUrl((String)metadata.get(Janus.Metadata.LOGO_URL.val()));
        em.setEula((String)metadata.get(Janus.Metadata.EULA.val()));
        em.setWorkflowState((String)metadata.get(Janus.Metadata.WORKFLOWSTATE.val()));
        em.setTwoLeggedOauthAllowed(false);
        if (metadata.get(Janus.Metadata.OAUTH_TWOLEGGEDALLOWED.val()) != null) {
            em.setTwoLeggedOauthAllowed((Boolean)metadata.get(Janus.Metadata.OAUTH_TWOLEGGEDALLOWED.val()));
        }
        em.setConsentNotRequired(false);
        if (metadata.get(Janus.Metadata.OAUTH_CONSENTNOTREQUIRED.val()) != null) {
            em.setConsentNotRequired((Boolean)metadata.get(Janus.Metadata.OAUTH_CONSENTNOTREQUIRED.val()));
        }
        em.setIdpVisibleOnly(false);
        if (metadata.get(Janus.Metadata.SS_IDP_VISIBLE_ONLY.val()) != null) {
            em.setIdpVisibleOnly((Boolean)metadata.get(Janus.Metadata.SS_IDP_VISIBLE_ONLY.val()));
        }
        Object c0Mail = metadata.get(Janus.Metadata.CONTACTS_0_EMAIL.val());
        if (metadata.get(Janus.Metadata.CONTACTS_0_TYPE.val()) != null && !EntityMetadata.emptyString(c0Mail)) {
            Contact contact = new Contact();
            contact.setEmailAddress((String)c0Mail);
            contact.setGivenName((String)metadata.get(Janus.Metadata.CONTACTS_0_GIVENNAME.val()));
            contact.setSurName((String)metadata.get(Janus.Metadata.CONTACTS_0_SURNAME.val()));
            Object phone = metadata.get(Janus.Metadata.CONTACTS_0_TELEPHONE.val());
            contact.setTelephoneNumber(EntityMetadata.getPhoneAsString(phone));
            contact.setType(Contact.Type.valueOf((String)metadata.get(Janus.Metadata.CONTACTS_0_TYPE.val())));
            em.addContact(contact);
        }
        Object c1Mail = metadata.get(Janus.Metadata.CONTACTS_1_EMAIL.val());
        if (metadata.get(Janus.Metadata.CONTACTS_1_TYPE.val()) != null && !EntityMetadata.emptyString(c1Mail)) {
            Contact contact = new Contact();
            contact.setEmailAddress((String)c1Mail);
            contact.setGivenName((String)metadata.get(Janus.Metadata.CONTACTS_1_GIVENNAME.val()));
            contact.setSurName((String)metadata.get(Janus.Metadata.CONTACTS_1_SURNAME.val()));
            Object phone = metadata.get(Janus.Metadata.CONTACTS_1_TELEPHONE.val());
            contact.setTelephoneNumber(EntityMetadata.getPhoneAsString(phone));
            contact.setType(Contact.Type.valueOf((String)metadata.get(Janus.Metadata.CONTACTS_1_TYPE.val())));
            em.addContact(contact);
        }
        Object c2Mail = metadata.get(Janus.Metadata.CONTACTS_2_EMAIL.val());
        if (metadata.get(Janus.Metadata.CONTACTS_2_TYPE.val()) != null && !EntityMetadata.emptyString(c2Mail)) {
            Contact contact = new Contact();
            contact.setEmailAddress((String)c2Mail);
            contact.setGivenName((String)metadata.get(Janus.Metadata.CONTACTS_2_GIVENNAME.val()));
            contact.setSurName((String)metadata.get(Janus.Metadata.CONTACTS_2_SURNAME.val()));
            Object phone = metadata.get(Janus.Metadata.CONTACTS_2_TELEPHONE.val());
            contact.setTelephoneNumber(EntityMetadata.getPhoneAsString(phone));
            contact.setType(Contact.Type.valueOf((String)metadata.get(Janus.Metadata.CONTACTS_2_TYPE.val())));
            em.addContact(contact);
        }
        return em;
    }

    private static boolean emptyString(Object o) {
        return !(o instanceof String) || "".equals(((String)o).trim());
    }

    private static String getPhoneAsString(Object p) {
        String phone = null;
        if (p instanceof String) {
            phone = (String)p;
        } else if (p instanceof Integer) {
            phone = p.toString();
        }
        return phone;
    }

    private void addContact(Contact contact) {
        this.contacts.add(contact);
    }

    public void setAppTitle(String appTitle) {
        this.appTitle = appTitle;
    }

    public void setAppIcon(String appIcon) {
        this.appIcon = appIcon;
    }

    public void setAppDescription(String appDescription) {
        this.appDescription = appDescription;
    }

    public void setAppThumbNail(String appThumbNail) {
        this.appThumbNail = appThumbNail;
    }

    public void setAppEntityId(String appEntityId) {
        this.appEntityId = appEntityId;
    }

    public void setOauthCallbackUrl(String oauthCallbackUrl) {
        this.oauthCallbackUrl = oauthCallbackUrl;
    }

    public void setTwoLeggedOauthAllowed(boolean twoLeggedOauthAllowed) {
        this.twoLeggedOauthAllowed = twoLeggedOauthAllowed;
    }

    public void setOauthConsumerKey(String oauthConsumerKey) {
        this.oauthConsumerKey = oauthConsumerKey;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public String getAppIcon() {
        return this.appIcon;
    }

    public String getAppDescription() {
        return this.appDescription;
    }

    public String getAppThumbNail() {
        return this.appThumbNail;
    }

    public String getAppEntityId() {
        return this.appEntityId;
    }

    public String getOauthCallbackUrl() {
        return this.oauthCallbackUrl;
    }

    public boolean isTwoLeggedOauthAllowed() {
        return this.twoLeggedOauthAllowed;
    }

    public String getOauthConsumerKey() {
        return this.oauthConsumerKey;
    }

    public void setOauthConsumerSecret(String oauthConsumerSecret) {
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public String getOauthConsumerSecret() {
        return this.oauthConsumerSecret;
    }

    public String getAppLogoUrl() {
        return this.appLogoUrl;
    }

    public String getAppHomeUrl() {
        return this.appHomeUrl;
    }

    public void setAppLogoUrl(String appLogoUrl) {
        this.appLogoUrl = appLogoUrl;
    }

    public void setAppHomeUrl(String appHomeUrl) {
        this.appHomeUrl = appHomeUrl;
    }

    public List<Contact> getContacts() {
        return UnmodifiableList.decorate(this.contacts);
    }

    public boolean isIdpVisibleOnly() {
        return this.isIdpVisibleOnly;
    }

    public void setIdpVisibleOnly(boolean idpVisibleOnly) {
        this.isIdpVisibleOnly = idpVisibleOnly;
    }

    public String getEula() {
        return this.eula;
    }

    public void setEula(String eula) {
        this.eula = eula;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isConsentNotRequired() {
        return this.consentNotRequired;
    }

    public void setConsentNotRequired(boolean consentNotRequired) {
        this.consentNotRequired = consentNotRequired;
    }

    public String getWorkflowState() {
        return this.workflowState;
    }

    public void setWorkflowState(String workflowState) {
        this.workflowState = workflowState;
    }
}

