/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.janus;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nl.surfnet.coin.janus.Janus;
import nl.surfnet.coin.janus.domain.ARP;
import nl.surfnet.coin.janus.domain.EntityMetadata;
import nl.surfnet.coin.janus.domain.JanusEntity;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class JanusRestClient
implements Janus {
    private static Logger LOG = LoggerFactory.getLogger(JanusRestClient.class);
    private RestTemplate restTemplate = new RestTemplate();
    private URI janusUri;
    private String user;
    private String secret;

    public JanusRestClient() {
        this.restTemplate.setMessageConverters(Arrays.asList(new MappingJacksonHttpMessageConverter()));
    }

    @Override
    public EntityMetadata getMetadataByEntityId(String entityId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("entityid", entityId);
        Collection metadataAsStrings = CollectionUtils.collect(Arrays.asList(Janus.Metadata.values()), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((Janus.Metadata)((Object)input)).val();
            }
        });
        parameters.put("keys", StringUtils.join((Collection)metadataAsStrings, (char)','));
        try {
            URI signedUri = this.sign("getMetadata", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
            Map restResponse = (Map)this.restTemplate.getForObject(signedUri, Map.class);
            Assert.notNull((Object)restResponse, (String)"Rest response from Janus should not be null");
            if (LOG.isTraceEnabled()) {
                LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
            }
            EntityMetadata entityMetadata = EntityMetadata.fromMetadataMap(restResponse);
            entityMetadata.setAppEntityId(entityId);
            return entityMetadata;
        }
        catch (IOException e) {
            LOG.error("While doing Janus-request", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getEntityIdsByMetaData(Janus.Metadata key, String value) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", key.val());
        parameters.put("value", value);
        try {
            URI signedUri = this.sign("findIdentifiersByMetadata", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
            List restResponse = (List)this.restTemplate.getForObject(signedUri, List.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
            }
            return restResponse;
        }
        catch (IOException e) {
            LOG.error("While doing Janus-request", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getAllowedSps(String idpentityid) {
        return this.getAllowedSps(idpentityid, null);
    }

    @Override
    public List<String> getAllowedSps(String idpentityid, String revision) {
        Assert.hasText((String)idpentityid, (String)"idpentityid is a required parameter");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("idpentityid", idpentityid);
        if (!StringUtils.isBlank((String)revision)) {
            parameters.put("idprevision", revision);
        }
        try {
            URI signedUri = this.sign("getAllowedSps", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
            List restResponse = (List)this.restTemplate.getForObject(signedUri, List.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
            }
            return restResponse;
        }
        catch (IOException e) {
            LOG.error("While doing Janus-request", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EntityMetadata> getSpList() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Collection metadataAsStrings = CollectionUtils.collect(Arrays.asList(Janus.Metadata.values()), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((Janus.Metadata)((Object)input)).val();
            }
        });
        parameters.put("keys", StringUtils.join((Collection)metadataAsStrings, (char)','));
        try {
            URI signedUri = this.sign("getSpList", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
            Map restResponse = (Map)this.restTemplate.getForObject(signedUri, Map.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
            }
            ArrayList<EntityMetadata> entities = new ArrayList<EntityMetadata>();
            for (Map.Entry entry : restResponse.entrySet()) {
                String entityId = (String)entry.getKey();
                EntityMetadata e = EntityMetadata.fromMetadataMap((Map)entry.getValue());
                e.setAppEntityId(entityId);
                entities.add(e);
            }
            return entities;
        }
        catch (IOException e) {
            LOG.error("While doing Janus-request", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EntityMetadata> getIdpList() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Collection metadataAsStrings = CollectionUtils.collect(Arrays.asList(Janus.Metadata.values()), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((Janus.Metadata)((Object)input)).val();
            }
        });
        parameters.put("keys", StringUtils.join((Collection)metadataAsStrings, (char)','));
        try {
            URI signedUri = this.sign("getIdpList", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
            Map restResponse = (Map)this.restTemplate.getForObject(signedUri, Map.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
            }
            ArrayList<EntityMetadata> entities = new ArrayList<EntityMetadata>();
            for (Map.Entry entry : restResponse.entrySet()) {
                String entityId = (String)entry.getKey();
                EntityMetadata e = EntityMetadata.fromMetadataMap((Map)entry.getValue());
                e.setAppEntityId(entityId);
                entities.add(e);
            }
            return entities;
        }
        catch (IOException e) {
            LOG.error("While doing Janus-request", (Throwable)e);
            return null;
        }
    }

    @Override
    public ARP getArp(String entityId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("entityid", entityId);
        URI signedUri = null;
        try {
            signedUri = this.sign("arp", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
        }
        catch (IOException e) {
            LOG.error("Could not do ARP request to Janus", (Throwable)e);
        }
        Map restResponse = (Map)this.restTemplate.getForObject(signedUri, Map.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
        }
        return restResponse == null ? null : ARP.fromRestResponse(restResponse);
    }

    @Override
    public boolean isConnectionAllowed(String spEntityId, String idpEntityId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("spentityid", spEntityId);
        parameters.put("idpentityid", idpEntityId);
        URI signedUri = null;
        try {
            signedUri = this.sign("isConnectionAllowed", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
        }
        catch (IOException e) {
            LOG.error("Could not do isConnectionAllowed request to Janus", (Throwable)e);
        }
        List restResponse = (List)this.restTemplate.getForObject(signedUri, List.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
        }
        return CollectionUtils.isEmpty((Collection)restResponse) ? false : (Boolean)restResponse.get(0);
    }

    @Override
    public JanusEntity getEntity(String entityId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("entityid", entityId);
        URI signedUri = null;
        try {
            signedUri = this.sign("getEntity", parameters);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signed Janus-request is: {}", (Object)signedUri);
            }
        }
        catch (IOException e) {
            LOG.error("Could not do getEntity request to Janus", (Throwable)e);
        }
        Map restResponse = (Map)this.restTemplate.getForObject(signedUri, Map.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Janus-request returned: {}", (Object)restResponse.toString());
        }
        return restResponse == null ? null : JanusEntity.fromJanusResponse(restResponse);
    }

    private URI sign(String method, Map<String, String> parameters) throws IOException {
        MessageDigest digest;
        TreeMap<String, String> keys = new TreeMap<String, String>();
        keys.put("janus_key", this.user);
        keys.put("method", method);
        keys.putAll(parameters);
        keys.put("rest", "1");
        keys.put("userid", this.user);
        Set keySet = keys.keySet();
        StringBuilder toSign = new StringBuilder(this.secret);
        for (String key : keySet) {
            toSign.append(key);
            toSign.append((String)keys.get(key));
        }
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot use algorithm SHA-512", e);
        }
        digest.reset();
        String charsetName = "UTF-8";
        byte[] input = digest.digest(toSign.toString().getBytes("UTF-8"));
        char[] value = Hex.encodeHex((byte[])input);
        String janus_sig = new String(value);
        keys.put("janus_sig", janus_sig);
        StringBuilder url = new StringBuilder();
        keySet = keys.keySet();
        for (String key : keySet) {
            if (url.length() > 0) {
                url.append('&');
            }
            url.append(key).append('=').append(URLEncoder.encode((String)keys.get(key), "UTF-8"));
        }
        String uri = url.toString();
        return URI.create(this.janusUri + "?" + uri);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public void setJanusUri(URI janusUri) {
        this.janusUri = janusUri;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void setSecret(String secret) {
        this.secret = secret;
    }
}

