drop table if exists saml_persistent_id;

create table saml_persistent_id (persistent_id varchar(255), user_uuid varchar(255) not null, service_provider_uuid varchar(255) not null);

insert into saml_persistent_id (persistent_id, user_uuid, service_provider_uuid) values ('persistent', 'user_uuid', 'whatever');

drop table if exists service_provider_group_acl;
create table service_provider_group_acl (
  id bigint generated by default as identity (start with 1),
  group_provider_id bigint not null,
  spentityid varchar(1024) not null,
        allow_groups bit,
        allow_members bit,
        primary key (id)
);

drop table if exists group_provider;
create table group_provider (
  id bigint generated by default as identity (start with 1),
  identifier varchar(255) not null,
  name varchar(255) not null,
  classname varchar(255) not null,
  logo_url varchar(1024) null,
  primary key (id)
);

drop table if exists group_provider_user_oauth;
create table group_provider_user_oauth (
  provider_id varchar(255) not null,
  user_id varchar(255) not null,
  oauth_token varchar(1024) not null,
  oauth_secret varchar(1024) not null,
  primary key (provider_id,user_id)
);

drop table if exists group_provider_decorator;
create table group_provider_decorator (
  id bigint generated by default as identity (start with 1),
  group_provider_id bigint not null,
  classname varchar(255) not null ,
  primary key (id)
) ;
create table group_provider_decorator_option (
  group_provider_decorator_id bigint not null,
  name varchar(255) not null ,
  value varchar(255) not null ,
  primary key (group_provider_decorator_id,name)
);
create table group_provider_filter (
  id bigint generated by default as identity (start with 1),
  group_provider_id bigint not null,
  type varchar(255) not null ,
  classname varchar(255) not null ,
  primary key (id)
);
create table group_provider_filter_option (
  group_provider_filter_id bigint not null,
  name varchar(255) not null ,
  value varchar(255) not null ,
  primary key (group_provider_filter_id,name)
);
create table group_provider_option (
  group_provider_id bigint not null,
  name varchar(255) not null ,
  value varchar(255) not null ,
  primary key (group_provider_id,name)
); 
create table group_provider_precondition (
  id bigint generated by default as identity (start with 1),
  group_provider_id bigint not null,
  classname varchar(255) default null,
  primary key (id)
);
create table group_provider_precondition_option (
  group_provider_precondition_id bigint not null,
  name varchar(255) not null ,
  value varchar(255) not null ,
  primary key (group_provider_precondition_id)
);

insert into service_provider_group_acl (id, group_provider_id, spentityid, allow_groups, allow_members) values (1, 9, 'https://serviceregistry.test.surfconext.nl/simplesaml/module.php/saml/sp/metadata.php/default-sp', 1, 1);
insert into service_provider_group_acl (id, group_provider_id, spentityid, allow_groups, allow_members) values (2, 5, 'https://testsp.dev.surfconext.nl/shibboleth', 1, 1);
insert into service_provider_group_acl (id, group_provider_id, spentityid, allow_groups, allow_members) values (3, 5, 'https://testsp.test.surfconext.nl/shibboleth', 1, 1);

insert into group_provider_user_oauth (provider_id, user_id, oauth_token, oauth_secret) values ('avans','urn:collab:person:test.surfguest.nl:tester', 'replaced_by_dummy_value', 'replaced_by_dummy_value');
insert into group_provider_user_oauth (provider_id, user_id, oauth_token, oauth_secret) values ('hz', 'urn:collab:person:test.surfguest.nl:tester2', 'replaced_by_dummy_value', 'replaced_by_dummy_value');
insert into group_provider_user_oauth (provider_id, user_id, oauth_token, oauth_secret) values ('avans', 'urn:collab:person:test.surfguest.nl:tester2', 'replaced_by_dummy_value', 'replaced_by_dummy_value');

insert into group_provider (id, identifier, name, classname, logo_url) values (4, 'hz', 'HZ', 'EngineBlock_Group_Provider_OpenSocial_Oauth_ThreeLegged', 'https://wayf-test.surfnet.nl/federate/surfnet/img/logo/hzeeland.png');
insert into group_provider (id, identifier, name, classname) values (5, 'grouper', 'SURFteams grouper', 'EngineBlock_Group_Provider_Grouper');
insert into group_provider (id, identifier, name, classname, logo_url) values (9, 'avans', 'Avans', 'EngineBlock_Group_Provider_OpenSocial_Oauth_ThreeLegged', 'https://wayf-test.surfnet.nl/federate/surfnet/img/logo/avans.png');


INSERT INTO group_provider_decorator (id, group_provider_id, classname)
VALUES
  (49,5,'EngineBlock_Group_Provider_Decorator_GroupIdReplace');

INSERT INTO group_provider_decorator (id, group_provider_id, classname)
VALUES
  (72,9,'EngineBlock_Group_Provider_Decorator_GroupIdReplace');

INSERT INTO group_provider_decorator (id, group_provider_id, classname)
VALUES
  (73,9,'EngineBlock_Group_Provider_Decorator_UserIdReplace');

INSERT INTO group_provider_decorator (id, group_provider_id, classname)
VALUES
  (74,4,'EngineBlock_Group_Provider_Decorator_GroupIdReplace');

INSERT INTO group_provider_decorator (id, group_provider_id, classname)
VALUES
  (75,4,'EngineBlock_Group_Provider_Decorator_UserIdReplace');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (49,'replace','$1');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (49,'search','|urn:collab:group:test.surfteams.nl:(.+)|');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (72,'replace','$1');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (72,'search','|urn:collab:group:avans.nl:(.+)|');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (73,'replace','tstidm7');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (73,'search','|.+|');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (74,'replace','$1');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (74,'search','|urn:collab:group:hz.nl:(.+)|');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (75,'replace','$1');

INSERT INTO group_provider_decorator_option (group_provider_decorator_id, name, value)
VALUES
  (75,'search','|urn:collab:person:hz.nl:(.+)|');

INSERT INTO group_provider_filter (id, group_provider_id, type, classname)
VALUES
  (52,5,'group','EngineBlock_Group_Provider_Filter_ModelProperty_PregReplace');

INSERT INTO group_provider_filter (id, group_provider_id, type, classname)
VALUES
  (75,9,'group','EngineBlock_Group_Provider_Filter_ModelProperty_PregReplace');

INSERT INTO group_provider_filter (id, group_provider_id, type, classname)
VALUES
  (76,9,'groupMember','EngineBlock_Group_Provider_Filter_ModelProperty_PregReplace');

INSERT INTO group_provider_filter (id, group_provider_id, type, classname)
VALUES
  (77,4,'group','EngineBlock_Group_Provider_Filter_ModelProperty_PregReplace');

INSERT INTO group_provider_filter (id, group_provider_id, type, classname)
VALUES
  (78,4,'groupMember','EngineBlock_Group_Provider_Filter_ModelProperty_PregReplace');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (52,'property','id');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (52,'replace','urn:collab:group:test.surfteams.nl:$1');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (52,'search','|(.+)|');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (75,'property','id');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (75,'replace','urn:collab:group:avans.nl:$1');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (75,'search','|(.+)|');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (76,'property','id');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (76,'replace','urn:collab:person:avans.nl:$1');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (76,'search','|(.+)|');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (77,'property','id');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (77,'replace','urn:collab:group:hz.nl:$1');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (77,'search','|(.+)|');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (78,'property','id');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (78,'replace','urn:collab:person:hz.nl:$1');

INSERT INTO group_provider_filter_option (group_provider_filter_id, name, value)
VALUES
  (78,'search','|(.+)|');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'adapter','EngineBlock_Http_Client_Adapter_Curl');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.accessTokenUrl','https://rest.hz.nl/AccessToken.ashx');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.authorizeUrl','https://rest.hz.nl/UserAuthorize.aspx');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.callbackUrl','https://profile.test.surfconext.nl/profile/group-oauth/consume/hz');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.consumerKey','replaced_by_dummy_value');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.consumerSecret','replaced_by_dummy_value');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.requestMethod','GET');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.requestScheme','QUERYSTRING');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.requestTokenUrl','https://rest.hz.nl/RequestToken.ashx');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.rsaPrivateKey','');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.rsaPublicKey','');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.signatureMethod','HMAC-SHA1');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.siteUrl','https://rest.hz.nl');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'auth.userAuthorizationUrl','https://rest.hz.nl/UserAuthorize.aspx');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'password','replaced_by_dummy_value');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'timeout','3');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'url','https://rest.hz.nl/api');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (4,'user','engine');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'host','grouper.test.surfconext.nl');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'password','replaced_by_dummy_value');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'path','/grouper-ws/servicesRest');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'protocol','https');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'ssl_verifyhost','true');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'ssl_verifypeer','false');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'timeout','10');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'user','engine');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (5,'version','v1_6_000');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.accessTokenUrl','https://publicapi.avans.nl/oauth/access_token');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.authorizeUrl','https://publicapi.avans.nl/oauth/saml.php');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.callbackUrl','https://profile.test.surfconext.nl/profile/group-oauth/consume/avans');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.consumerKey','replaced_by_dummy_value');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.consumerSecret','replaced_by_dummy_value');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.requestMethod','GET');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.requestScheme','QUERYSTRING');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.requestTokenUrl','https://publicapi.avans.nl/oauth/request_token');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.rsaPrivateKey','');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.rsaPublicKey','');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.signatureMethod','HMAC-SHA1');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.siteUrl','https://publicapi.avans.nl');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'auth.userAuthorizationUrl','https://publicapi.avans.nl/oauth/saml.php');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'password','replaced_by_dummy_value');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'timeout','10');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'url','https://publicapi.avans.nl/oauth');

INSERT INTO group_provider_option (group_provider_id, name, value)
VALUES
  (9,'user','engine');

INSERT INTO group_provider_precondition (id, group_provider_id, classname)
VALUES
  (65,9,'EngineBlock_Group_Provider_Precondition_OpenSocial_Oauth_AccessTokenExists');

INSERT INTO group_provider_precondition (id, group_provider_id, classname)
VALUES
  (66,9,'EngineBlock_Group_Provider_Precondition_UserId_PregMatch');

INSERT INTO group_provider_precondition (id, group_provider_id, classname)
VALUES
  (67,4,'EngineBlock_Group_Provider_Precondition_OpenSocial_Oauth_AccessTokenExists');

INSERT INTO group_provider_precondition (id, group_provider_id, classname)
VALUES
  (68,4,'EngineBlock_Group_Provider_Precondition_UserId_PregMatch');

INSERT INTO group_provider_precondition_option (group_provider_precondition_id, name, value)
VALUES
  (66,'search','|(.+)|');

INSERT INTO group_provider_precondition_option (group_provider_precondition_id, name, value)
VALUES
  (68,'search','|urn:collab:person:hz.nl:(.+)|');

