# SURFnet Collaboration Infrastructure Java Stack

The java Stack for the SURFnet Collaboration Infrastructure comprises of the following components:

- Grouper
- Shindig
- SURFconext Portal
- SURFconext Teams
- SURFconext Calendar*
- SURFconext Messaging Broker*

* NB. The Calendar and Messaging Broker are optional, they might not reach production status.

This readme provides the means to install the above described java components.
Full information is available at http://www.surfnet.nl

## Requirements

* Apache httpd
* Java > 1.5
* MySQL > 5.x with settings:
    * default-storage-engine=InnoDB (recommended)
    * default-collation=utf8_unicode_ci (recommended)
* Apache Tomcat
* LDAP
* Service Registry
* wget


## Installation

### Install Shibboleth

Shibboleth by default is not in the yum repo's provided for RHEL, so we have
to download a repo that contains Shibboleth.

Download the Shibboleth yum repository file into your yum repository directory 
/etc/yum.repos.d

    wget http://download.opensuse.org/repositories/security://shibboleth/RHEL_5/security:shibboleth.repo

Install Shibboleth using the following command

    yum install shibboleth --exclude=*.i386


### Configuring Shibboleth

The following configuration files are provided for Shibboleth

- attribute-map.xml     \(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- attribute-policy.xml  \(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- shibboleth2.xml\*       \(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)

\* NB Fetch the correct shibboleth2.xml. file for the environment you are installing. Rename the file to shibboleth2.xml

The following error pages are provided for Shibboleth

- accessError.html		\(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- globalLogout.html		\(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- localLogout.html		\(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- metadataError.html	\(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- partialLogout.html	\(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- sessionError.html		\(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)
- sslError.html			\(located at \<\<EXTRACTED_TARBALL_PATH\>\>/shibboleth/\)

Copy the attribute-map and shibboleth2.xml files to the shibboleth configuration directory /etc/shibboleth

Make changes to the shibboleth2.xml file if necessary.

Now copy the error pages to the shibboleth configuration directory \(/etc/shibboleth\)


### Install Apache Configuration Files

Install the following apache Configuration files:

- Grouper (grouper.conf)\*
- Shindig (os.conf, star.os.conf)\*
- SURFconext Portal (portal.conf)\*
- Shibboleth (shib.conf)
- AJP (proxy_ajp.conf)
- default (default.conf)\*

\* NB. You have to fetch the correct file corresponding to the environment you are installing.

The files are located in at \<\<EXTRACTED_TARBALL_PATH\>\>/httpd/conf.d Place these files in you apache
configuration directory. Usually it is located at:

    /etc/httpd/conf.d

It may be necessary to change the configuration files, for some values are based on a server's 
config e.g. ip address, etc.

### Install Grouper

Install grouper according to the install manual provided by the grouper install package.
You can obtain the latest grouper package from the following location:

    http://bamboo-dev.coin.surfnetlabs.nl/org/surfnet/coin/grouper-dist/<<VERSION>>/grouper-dist-<<VERSION>>-bin.tar.gz

Replace the \<\<VERSION\>\> tags with the latest (stable) version.
Note that the repository is password protected, please contact SURFnet (coin-beheer@surfnet.nl) to obtain a copy of the password


### Install Shindig

Install shindig according to the install manual provided by the install package.
You can obtain the latest package from the following location:

    http://bamboo-dev.coin.surfnetlabs.nl/org/surfnet/coin/coin-shindig-dist/<<VERSION>>/coin-shindig-dist-<<VERSION>>-bin.tar.gz

Replace the \<\<VERSION\>\> tags with the latest (stable) version.
Note that the repository is password protected, please contact SURFnet (coin-beheer@surfnet.nl) to obtain a copy of the password


### Install SURFconext Portal

Install the portal according to the install manual provided by the install package.
You can obtain the latest package from the following location:

    http://bamboo-dev.coin.surfnetlabs.nl/org/surfnet/coin/coin-portal-dist/<<VERSION>>/coin-portal-dist-<<VERSION>>-bin.tar.gz

Replace the \<\<VERSION\>\> tags with the latest (stable) version.
Note that the repository is password protected, please contact SURFnet (coin-beheer@surfnet.nl) to obtain a copy of the password


### Install SURFconext Teams

Install the calendar according to the install manual provided by the install package.
You can obtain the latest package from the following location:

    http://bamboo-dev.coin.surfnetlabs.nl/org/surfnet/coin/coin-teams-dist/<<VERSION>>/coin-teams-dist-<<VERSION>>-bin.tar.gz

Replace the \<\<VERSION\>\> tags with the latest (stable) version.
Note that the repository is password protected, please contact SURFnet (coin-beheer@surfnet.nl) to obtain a copy of the password


### Install SURFconext Calendar

Install the calendar according to the install manual provided by the install package.
You can obtain the latest package from the following location:

    http://bamboo-dev.coin.surfnetlabs.nl/org/surfnet/coin/coin-calendar-dist/<<VERSION>>/coin-calendar-dist-<<VERSION>>-bin.tar.gz

Replace the \<\<VERSION\>\> tags with the latkest (stable) version.
Note that the repository is password protected, please contact SURFnet (coin-beheer@surfnet.nl) to obtain a copy of the password


### Install SURFconext Message Broker

Install the message broker according to the install manual provided by the install package.
You can obtain the latest package from the following location:

    http://bamboo-dev.coin.surfnetlabs.nl/org/surfnet/coin/coin-messaging-dist/<<VERSION>>/coin-messaging-dist-<<VERSION>>-bin.tar.gz

Replace the \<\<VERSION\>\> tags with the latkest (stable) version.
Note that the repository is password protected, please contact SURFnet (coin-beheer@surfnet.nl) to obtain a copy of the password
