/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.opensocial.service;

import nl.surfnet.coin.opensocial.util.SharedEnvironment;
import org.opensocial.Client;
import org.opensocial.auth.AuthScheme;
import org.opensocial.auth.OAuth2LeggedScheme;
import org.opensocial.providers.Provider;
import org.opensocial.providers.ShindigProvider;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractOpenSocialService {
    @Autowired
    private SharedEnvironment environment;

    protected Client getClient(String loggedInUser) {
        ShindigProvider provider = new ShindigProvider(true);
        provider.setRestEndpoint(this.environment.getOpenSocialUrl() + "/rest/");
        provider.setRpcEndpoint(null);
        provider.setVersion("0.9");
        OAuth2LeggedScheme scheme = new OAuth2LeggedScheme(this.environment.getOauthKey(), this.environment.getOauthSecret(), loggedInUser);
        return new Client((Provider)provider, (AuthScheme)scheme);
    }

    public void setEnvironment(SharedEnvironment environment) {
        this.environment = environment;
    }
}

