/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.opensocial.service.impl;

import java.io.IOException;
import java.util.List;
import nl.surfnet.coin.opensocial.service.AbstractOpenSocialService;
import nl.surfnet.coin.opensocial.service.PersonService;
import org.opensocial.Request;
import org.opensocial.RequestException;
import org.opensocial.models.Person;
import org.springframework.stereotype.Component;

@Component(value="opensocialPersonService")
public class PersonServiceImpl
extends AbstractOpenSocialService
implements PersonService {
    private static final String REST_TEMPLATE = "people/{guid}/{selector}/{pid}";
    protected static final String SELF = "@self";

    @Override
    public Person getPerson(String userId, String loggedInUser) {
        Request request = new Request(REST_TEMPLATE, "people.get", "GET");
        request.setModelClass(Person.class);
        request.setSelector(SELF);
        request.setGuid(userId);
        try {
            return (Person)this.getClient(loggedInUser).send(request).getEntry();
        }
        catch (RequestException e) {
            throw new IllegalArgumentException("Unable to retrieve the person with uid: '" + userId + "'", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to retrieve the person with uid: '" + userId + "'", e);
        }
    }

    @Override
    public List<Person> getPeople(String groupId, String loggedInUser) {
        Request request = new Request(REST_TEMPLATE, "people.get", "GET");
        request.setModelClass(Person.class);
        request.setSelector(groupId);
        request.setGuid(loggedInUser);
        try {
            return this.getClient(loggedInUser).send(request).getEntries();
        }
        catch (RequestException e) {
            throw new IllegalArgumentException("Unable to retrieve the Group Members for groupId: '" + groupId + "'", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to retrieve the Group Members for groupId: '" + groupId + "'", e);
        }
    }
}

