/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.control;

import nl.surfnet.coin.portal.domain.Gadget;
import org.opensocial.models.Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;

/**
 * {@link Controller} that handles the saving and loading of user preferences of
 * gadgets.
 */
@Controller
public class PrefsController extends BaseController {

  private static Logger logger = LoggerFactory.getLogger(PrefsController.class);
  private static final String ERROR_RESPONSE = "error";

  @RequestMapping(value = "/saveprefs.shtml", method = RequestMethod.POST)
  @ResponseBody
  public boolean savePrefs(ModelMap modelMap, HttpServletRequest request) throws UnsupportedEncodingException {

    Gadget gadget = getGadget(request, request.getParameter("gadgetId"));

    if (gadget == null) {
      logger.info("Gadget not found");
      return false;
    }

    final Person person = getPerson(request);
    if (!person.getId().equals(gadget.getTab().getOwner())) {
      logger.warn("Person is not the owner of gadget");
      return false;
    }

    String paramString = "";

    @SuppressWarnings("unchecked")
    Enumeration<String> params = request.getParameterNames();
    while (params.hasMoreElements()) {
      String param = params.nextElement();
      if (param.startsWith("up_")) {
        if (!paramString.equals("")) {
          paramString += "&";
        }
        paramString += param.substring(3) + "=" + URLEncoder.encode(request.getParameter(param), "UTF-8");
      }
    }

    gadget.setPrefs(paramString);
    gadgetService.saveOrUpdate(gadget);
    return true;
  }

  @RequestMapping(value = "/getprefs.shtml", method = RequestMethod.GET)
  @ResponseBody
  public String getPrefs(ModelMap modelMap, HttpServletRequest request) {
    Gadget gadget = getGadget(request, request.getParameter("gadgetId"));
    if (gadget == null) {
      return ERROR_RESPONSE;
    }
    return gadget.getPrefs();
  }

}
