/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package nl.surfnet.coin.portal.domain;


import org.opensocial.models.Group;

/**
 * An {@link org.opensocial.models.Group} that is aware of external groups
 * 
 */
public class ExternalAwareGroup extends Group {

  private static final String EXTERNAL_GROUP_PREFIX = "urn:collab:group:";

  public ExternalAwareGroup(Group group) {
    super();
    setField("description", group.getDescription());
    setField("id", group.getId());
    setField("title", getNiceTitle(group.getTitle()));
  }

  private String getNiceTitle(String title) {
    String id = super.getId();
    if (id.startsWith(EXTERNAL_GROUP_PREFIX)) {
      int indexOf = id.indexOf(":", EXTERNAL_GROUP_PREFIX.length());
      indexOf = (indexOf == -1 ? id.length() : indexOf);
      return title + " ("
          + id.substring(EXTERNAL_GROUP_PREFIX.length(), indexOf) + ")";
    } else {
      return title;
    }

  }

}
