/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package nl.surfnet.coin.portal.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

import nl.surfnet.coin.shared.domain.DomainObject;

import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;

/**
 * An invite for a sharedResource
 * 
 */
@SuppressWarnings("serial")
@Entity
@Proxy(lazy = false)
public class Invite extends DomainObject {

  private String invitee;

  private String email;

  @ManyToOne(fetch = FetchType.EAGER)
  @JoinColumn(name = "shared_resource_id")
  private SharedResource sharedResource;

  @Type(type = "nl.surfnet.coin.portal.domain.hibernate.InviteStatusUserType")
  private InviteStatus status;
  
  /**
   * Time of creation
   */
  @Column(name = "creation_timestamp")
  private Long creationTimestamp = System.currentTimeMillis();

  /**
   * @return the invitee
   */
  public String getInvitee() {
    return invitee;
  }

  /**
   * @param invitee
   *          the invitee to set
   */
  public void setInvitee(String invitee) {
    this.invitee = invitee;
  }

  /**
   * @return the email
   */
  public String getEmail() {
    return email;
  }

  /**
   * @param email
   *          the email to set
   */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * @return the status
   */
  public InviteStatus getStatus() {
    return status;
  }

  /**
   * @param status
   *          the status to set
   */
  public void setStatus(InviteStatus status) {
    this.status = status;
  }

  /**
   * @return the sharedResource
   */
  public SharedResource getSharedResource() {
    return sharedResource;
  }

  /**
   * @param sharedResource the sharedResource to set
   */
  public void setSharedResource(SharedResource sharedResource) {
    this.sharedResource = sharedResource;
  }

  /**
   * @return the creationTimestamp
   */
  public Long getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * @param creationTimestamp the creationTimestamp to set
   */
  public void setCreationTimestamp(Long creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
  }

  

}
