/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.domain;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

/**
 * A gadget that got shared by a person.
 */
@SuppressWarnings("serial")
@Entity
public class SharedGadget extends SharedResource {

  /**
   * This should point to a clone of the original gadget.
   */
  @OneToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
  @JoinColumn(name = "gadget_id")
  private Gadget prototype;

  /*
   * (non-Javadoc)
   * 
   * @see nl.surfnet.coin.portal.domain.SharedResource#getType()
   */
  @Override
  public SharedResourceType getType() {
    return SharedResourceType.Gadget;
  }

  /**
   * @return the prototype
   */
  public Gadget getPrototype() {
    return prototype;
  }

  /**
   * @param prototype
   *          the prototype to set
   */
  public void setPrototype(Gadget prototype) {
    this.prototype = prototype;
  }

  /*
   * (non-Javadoc)
   * 
   * @see nl.surfnet.coin.portal.domain.SharedResource#getName()
   */
  @Override
  public String getName() {
    return getPrototype().getDefinition().getTitle();
  }

  /*
   * (non-Javadoc)
   * 
   * @see nl.surfnet.coin.portal.domain.SharedResource#getTeam()
   */
  @Override
  public String getTeam() {
    return ((Tab) getPrototype().getTab()).getTeam();
  }

}
