/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package nl.surfnet.coin.portal.domain;

import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.hibernate.annotations.Proxy;

/**
 * Predefined TemplateTab
 * 
 */
@Entity
@Proxy(lazy = false)
@SuppressWarnings("serial")
public class TemplateTab extends AbstractTab {
  
  /**
   * The set of gadgetDefinitions on this templateTab.
   */
  @ManyToMany(fetch = FetchType.LAZY)
  private Set<GadgetDefinition> gadgetDefinitions;

  /**
   * Description of the template.
   */
  @NotNull
  @Size(min = 1, max = 255)
  private String description;

  /**
   * @return the gadgetDefinitions
   */
  public Set<GadgetDefinition> getGadgetDefinitions() {
    return gadgetDefinitions;
  }

  /**
   * @param gadgetDefinitions the gadgetDefinitions to set
   */
  public void setGadgetDefinitions(Set<GadgetDefinition> gadgetDefinitions) {
    this.gadgetDefinitions = gadgetDefinitions;
  }

  /**
   * @return the description
   */
  public String getDescription() {
    return description;
  }

  /**
   * @param description the description to set
   */
  public void setDescription(String description) {
    this.description = description;
  }
  
  

}
