/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package nl.surfnet.coin.portal.jsptags;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

/**
 * Parses the XHTML body content and writes only the text()
 * <p/>
 * Trims the text if {@literal maxvalue} > 0
 */
public class XHTMLToTextTag extends BodyTagSupport {
  private static final Logger logger = Logger.getLogger(XHTMLToTextTag.class);
  private String var;
  private int maxlength = 0;

  @Override
  public int doEndTag() throws JspException {

    // be sure to have a single root element (even though XML is not a String)
    String bodyContentString = bodyContent.getString();
    String text = "";

    if (StringUtils.hasText(bodyContentString)) {
      text = getTextFromHTMLFragment(bodyContentString, maxlength);
    }

    if (StringUtils.hasText(var)) {
      pageContext.setAttribute(var, text);
    } else {
      try {
        pageContext.getOut().write(text);
      } catch (IOException e) {
        logger.warn("Could not write body content to JSP", e);
      }
    }

    return EVAL_PAGE;
  }

  static String getTextFromHTMLFragment(String htmlFragment, int maxlength) {
    /*
     * We replace the first parapgrap as it contains the 'Page edited by...'
     */
    htmlFragment = org.apache.commons.lang.StringUtils.substringAfter(
        htmlFragment, "</p>");
    htmlFragment = htmlFragment.replaceAll("[\\t\\n\\x0B\\f\\r]", " ");
    htmlFragment = htmlFragment.replaceAll("\\<.*?>", "");
    htmlFragment = htmlFragment.trim();

    if (maxlength == 0 || htmlFragment.length() <= maxlength) {
      return htmlFragment;
    }

    String abbr = htmlFragment.substring(0, maxlength);
    return abbr.substring(0, abbr.lastIndexOf(' ')) + "...";
  }

  public String getVar() {
    return var;
  }

  public void setVar(String var) {
    this.var = var;
  }

  public int getMaxlength() {
    return maxlength;
  }

  public void setMaxlength(int maxlength) {
    this.maxlength = maxlength;
  }
}
