/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.service;

import nl.surfnet.coin.portal.domain.GadgetDefinition;
import nl.surfnet.coin.shared.service.GenericService;
import nl.surfnet.coin.shared.service.SortOrder;

import java.util.List;


/**
 * Service for managing {@link GadgetDefinition}
 */
public interface GadgetDefinitionService extends GenericService<GadgetDefinition> {

  /**
   * Find by Wild card. Returns only published GadgetDefinitions.
   *
   * @param query String with the search query
   * @return GadgetDefinitions
   */
  List<GadgetDefinition> searchByWildCard(String query);

  /**
   * Find by Wild card. Returns only published GadgetDefinitions that are not custom.
   *
   * @param query String with the search query
   * @return GadgetDefinitions
   */
  List<GadgetDefinition> searchByWildCardExcludeCustom(String query);

  /**
   * Find all GadgetDefinitions with status = published.
   *
   * @return List of {@link GadgetDefinition}'s
   */
  List<GadgetDefinition> findAllPublished();

  /**
   * Find all GadgetDefinitions with status = published that are not added by users
   *
   * @return List of {@link GadgetDefinition}'s
   */
  List<GadgetDefinition> findAllPublishedExcludeCustom();

  /**
   * Find all GadgetDefinitions with status = published that are not added by users ordered by number of installs
   *
   * @param sortOrder {@link SortOrder} (ASCENDING or DESCENDING)
   * @return sorted list of {@link GadgetDefinition}'s, can be empty
   */
  List<GadgetDefinition> findAllPublishedExcludeCustomOrderByPopularity(SortOrder sortOrder);

  /**
   * Find all GadgetDefinitions that need to be added to the Fixed Tab
   *
   * @return List of {@link GadgetDefinition}'s
   */
  List<GadgetDefinition> findAllFixedTabGadgets();

  /**
   * Finds {@link GadgetDefinition} by its URL. The URL is unique for each GadgetDefinition.
   *
   * @param url String with the URL of the gadget definition
   * @return {@link GadgetDefinition} or {@literal null} if none can be found
   */
  GadgetDefinition searchByUrl(String url);

}
