/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.service;

import java.util.List;

import nl.surfnet.coin.portal.domain.Gadget;
import nl.surfnet.coin.portal.domain.Tab;
import nl.surfnet.coin.shared.service.GenericService;


/**
 * 
 * Service for managing {@link Gadget}
 * 
 */
public interface GadgetService extends GenericService<Gadget> {
  
  /**
   * Get a count of all Gagdets on a tab.
   * 
   * @param tab
   *          tab where gadgets reside on
   * @return
   */
  int getCountByTab(Tab tab);
  
  /**
   * Get a count of all Gagdets on a tab.
   * 
   * @param tab
   *          tab where gadgets reside on
   * @param column
   *          column where gadget resides on
   * @return
   */
  int getCountByTabColumn(Tab tab, int column);
  
  /**
   * Get a all Gagdets on a tab for a specific column.
   * 
   * @param tab
   *          tab where gadgets reside on
   * @param column
   *          column where gadget resides on
   * @return
   */
  List<Gadget> getByTabColumn(Tab tab, int column);
  
  /**
   * Reorder gadgets
   * 
   * @param column1
   *          new order for column 1
   * @param column2
   *          new order for column 2
   * @param tab
   *          tab where gadgets reside on
   * @return
   */
  boolean reorderGadgets(String[] column1, String[] column2, Tab tab);
  
  /**
   * Increase the order of all gadgets of one specific tab with one
   * 
   * @param tab
   *          the tab
   *          
   * @return
   */
  void clearFirstSpot(Tab tab);
}
