/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.service;

import nl.surfnet.coin.portal.domain.Invite;
import nl.surfnet.coin.portal.domain.InviteStatus;
import nl.surfnet.coin.shared.service.GenericService;

import java.util.List;

/**
 * Service for managing {@link Invite}
 */
public interface InviteService extends GenericService<Invite> {

  /**
   * Find the recent invites by invitee Identifier
   *
   * @param inviteeId {@link String} the unique identifier of an invitee
   * @param status the {@link InviteStatus}
   * @return {@link List} containing the {@link Invite}s
   */
  List<Invite> findRecentByInvitee(String inviteeId, InviteStatus status);

  int getCountRecentByInvitee(String ownerId, InviteStatus status);

}
