/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package nl.surfnet.coin.portal.service.impl;

import java.util.List;

import nl.surfnet.coin.portal.domain.TextContent;
import nl.surfnet.coin.portal.service.TextContentService;
import nl.surfnet.coin.shared.service.GenericServiceHibernateImpl;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Component;

/**
 * @author steinwelberg
 * 
 */
@Component
public class TextContentServiceHibernateImpl extends
    GenericServiceHibernateImpl<TextContent> implements TextContentService {

  public TextContentServiceHibernateImpl() {
    super(TextContent.class);
  }

  @Override
  public TextContent getByField(String field) {
    Criterion crit = Restrictions.eq("field", field);
    List<TextContent> textContents = findByCriteria(crit);
    return textContents.isEmpty() ? null : textContents.get(0);
  }

}
