/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.util;

/**
 * 
 * CoinEnvironment
 * 
 */
public class CoinEnvironment {

  private String metadataUrl;
  private String idpMetadataUrl;
  private String gadgetServerBase;
  private String targetServerBase;
  private String version;
  private String containerName;
  private String landingPageRssFeeds;
  private boolean allowCustomGadgets;
  private int shindigDebug;
  private int shindigNocache;
  private String textFieldIntroduction;
  private String textFieldGettingStarted;
  private String profilePageUrl;

	/**
	 * Something like urn:collab:person:surfnet.nl:hansz or an empty String if
	 * you want Shibboleth to handle logins.
	 */
	private String mockLogin;
	private String mockName;
	private String mockUserStatus;

	public void setMetadataUrl(String metadataUrl) {
		this.metadataUrl = metadataUrl;
	}

	public String getMetadataUrl() {
		return metadataUrl;
	}

	public void setGadgetServerBase(String gadgetServerBase) {
		this.gadgetServerBase = gadgetServerBase;
	}

	public String getGadgetServerBase() {
		return gadgetServerBase;
	}

	/**
	 * @return the targetServerBase
	 */
	public String getTargetServerBase() {
		return targetServerBase;
	}

	/**
	 * @param targetServerBase
	 *            the targetServerBase to set
	 */
	public void setTargetServerBase(String targetServerBase) {
		this.targetServerBase = targetServerBase;
	}

	public void setMockLogin(String mockLogin) {
		this.mockLogin = mockLogin;
	}

	public String getMockLogin() {
		return mockLogin;
	}

	public void setMockName(String mockName) {
		this.mockName = mockName;
	}

	public String getMockName() {
		return mockName;
	}

  /**
   * @param mockUserStatus the mockUserStatus to set
   */
  public void setMockUserStatus(String mockUserStatus) {
    this.mockUserStatus = mockUserStatus;
  }

  /**
   * @return the mockUserStatus
   */
  public String getMockUserStatus() {
    return mockUserStatus;
  }

  /**
   * @return the version
   */
  public String getVersion() {
    return version;
  }

  /**
   * @param version the version to set
   */
  public void setVersion(String version) {
    this.version = version;
  }

  public void setContainerName(String containerName) {
    this.containerName = containerName;
  }

  public String getContainerName() {
    return containerName;
  }

  /**
   * 
   * @param idpMetadataUrl
   */
  public void setIdpMetadataUrl(String idpMetadataUrl) {
    this.idpMetadataUrl = idpMetadataUrl;
  }

  /**
   * 
   * @return
   */
  public String getIdpMetadataUrl() {
    return idpMetadataUrl;
  }

  /**
   * Getter to define if custom (user added) gadgets are allowed
   * @return {@value true} if a user can add custom gadgets (anywhere from the internet)
   */
  public boolean isAllowCustomGadgets() {
    return allowCustomGadgets;
  }

  public void setAllowCustomGadgets(boolean allowCustomGadgets) {
    this.allowCustomGadgets = allowCustomGadgets;
  }

  public void setShindigDebug(int shindigDebug) {
    this.shindigDebug = shindigDebug;
  }

  public int getShindigDebug() {
    return shindigDebug;
  }

  public void setShindigNocache(int shindigNocache) {
    this.shindigNocache = shindigNocache;
  }

  public int getShindigNocache() {
    return shindigNocache;
  }

  /**
   * @return locations of the RSS feed shown on the landing page as comma separated value
   */
  public String getLandingPageRssFeeds() {
    return landingPageRssFeeds;
  }

  public void setLandingPageRssFeeds(String landingPageRssFeeds) {
    this.landingPageRssFeeds = landingPageRssFeeds;
  }

  /**
   * @param textFieldIntroduction the textFieldIntroduction to set
   */
  public void setTextFieldIntroduction(String textFieldIntroduction) {
    this.textFieldIntroduction = textFieldIntroduction;
  }

  /**
   * @return the textFieldIntroduction
   */
  public String getTextFieldIntroduction() {
    return textFieldIntroduction;
  }

  /**
   * @param textFieldGettingStarted the textFieldGettingStarted to set
   */
  public void setTextFieldGettingStarted(String textFieldGettingStarted) {
    this.textFieldGettingStarted = textFieldGettingStarted;
  }

  /**
   * @return the textFieldGettingStarted
   */
  public String getTextFieldGettingStarted() {
    return textFieldGettingStarted;
  }

  public String getProfilePageUrl() {
    return profilePageUrl;
  }

  public void setProfilePageUrl(String profilePageUrl) {
    this.profilePageUrl = profilePageUrl;
  }
}
