/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.xml.namespace.NamespaceContext;

public class NamespaceResolver implements NamespaceContext {

  private Map<String, String> namespaceMap;
  private Map<String, String> reverseMap;
  
  public NamespaceResolver() {
    namespaceMap = new HashMap<String, String>();
    reverseMap = new HashMap<String, String>();
  }
  
  public NamespaceResolver addNamespace(String nsPrefix, String nsURI) {
    namespaceMap.put(nsPrefix, nsURI);
    reverseMap.put(nsURI, nsPrefix);
    return this;
  }
  
  public NamespaceResolver addNamespaces(Map<String, String> map) {
    namespaceMap.putAll(map);
    
    String[] values = map.values().toArray(new String[] {});
    String[] keys = map.keySet().toArray(new String[] {});
    for (int i = 0; i < values.length; i++) {
      reverseMap.put(values[i], keys[i]);
    }
    return this;
  }

  @Override
  public String getNamespaceURI(String prefix) {
    return namespaceMap.containsKey(prefix) ? namespaceMap.get(prefix) : null;
  }

  @Override
  public String getPrefix(String namespaceURI) {
    return reverseMap.containsKey(namespaceURI) ? reverseMap.get(namespaceURI) : null;
  }

  @Override
  public Iterator<String> getPrefixes(String namespaceURI) {
    if (reverseMap.containsKey(namespaceURI)) {
      Collection<String> reverseMapList = reverseMap.values();
      return reverseMapList.iterator();
    } else {
      return null;
    }
  }
}
