/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package nl.surfnet.coin.portal.util;

import nl.surfnet.coin.portal.domain.Tab;

import java.util.Comparator;

/**
 * {@link Comparator} for {@link Tab} based on the order
 *
 */
public class TabOrderComparator implements Comparator<Tab>{

  /* (non-Javadoc)
   * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
   */
  @Override
  public int compare(Tab o1, Tab o2) {
    int order1 = (o1 != null ? o1.getOrder() : 0);
    int order2 = (o2 != null ? o2.getOrder() : 0);
    return (order1 == order2) ? 0 : (order1 > order2 ? 1 : -1);
  }

}
