/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.control;

import java.util.Comparator;
import java.util.Locale;

import nl.surfnet.coin.portal.domain.IdentityProvider;

import org.springframework.util.StringUtils;

/**
 * 
 * Compares {@link IdentityProvider} based on displayName
 * 
 */
public class IdentityProviderComparator implements Comparator<IdentityProvider> {

  private static final Locale locale = new Locale("en");
  
  @Override
  public int compare(IdentityProvider o1, IdentityProvider o2) {
    if (o1 == null || !StringUtils.hasText(o1.getDisplayName(locale.getLanguage()))) {
      return -1;
    } else if (o2 == null || !StringUtils.hasText(o2.getDisplayName(locale.getLanguage()))) {
      return 1;
    }
    return o1.getDisplayName(locale.getLanguage()).compareTo(o2.getDisplayName(locale.getLanguage()));
  }

}
