/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.control;

import nl.surfnet.coin.portal.util.CoinEnvironment;
import org.opensocial.models.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;

@Controller
public class JSController extends BaseController {

  @Autowired
  private CoinEnvironment environment;

  @RequestMapping("/js/coin.js")
  public String js(ModelMap modelMap, HttpServletRequest request) {
    modelMap.addAttribute("environment", environment);

    // Person is logged in
    Person owner = getPerson(request);
    if (owner != null) {
      String ownerId = owner.getId();
      modelMap.addAttribute("viewerId", ownerId);
      modelMap.addAttribute("ownerId", ownerId);
    }
    return "js";
  }

}
