package nl.surfnet.coin.portal.control;

import nl.surfnet.coin.portal.domain.UserPreferences;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * {@link Controller} that handles portal preferences of users.
 */
@Controller
public class PortalPreferenceController extends BaseController {

  public static Logger logger = LoggerFactory.getLogger(PortalPreferenceController.class);

  /**
   * Revoke the permissions
   *
   * @param modelMap the {@link ModelMap}
   * @param request  the {@link HttpServletRequest}
   * @return whether the permissions where successfully revoked
   */
  @RequestMapping(value = "/set-gadget-permissions.shtml", method = RequestMethod.POST)
  @ResponseBody
  public boolean revokeGadgetPermissions(ModelMap modelMap, HttpServletRequest request) {
    final UserPreferences userPreferences = getPreferences(request);
    if (userPreferences == null) {
      logger.info("Could not fetch the user preferences");
      return false;
    }
    String value = request.getParameter("value");
    if (StringUtils.isBlank(value)) {
      logger.info("Could not resolve value");
      return false;
    }
    userPreferences.setInformationSharingPermissionGranted("true".equals(value));
    userPreferencesService.saveOrUpdate(userPreferences);
    return true;
  }
}