/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.control;

import nl.surfnet.coin.portal.domain.InviteStatus;
import nl.surfnet.coin.portal.domain.Tab;
import nl.surfnet.coin.portal.service.InviteService;
import nl.surfnet.coin.portal.util.CoinEnvironment;
import org.opensocial.models.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;

import java.util.List;

/**
 * {@link Controller} for Tabs in the overview page
 */
@Controller
public class TabOverviewController extends BaseController {

  @Autowired
  private CoinEnvironment environment;

  @Autowired
  private InviteService inviteService;

  @RequestMapping("/taboverview.shtml")
  public String taboverview(ModelMap modelMap, HttpServletRequest request) {
    populateModelMapWithPreferences(modelMap, request);

    modelMap.addAttribute("environment", environment);

    Person owner = getPerson(request);

    List<Tab> favoriteTabList = tabService.findFavorites(owner.getId(), true);
    modelMap.addAttribute("favoriteTabList", favoriteTabList);

    List<Tab> manageTabList = tabService.findFavorites(owner.getId(), false);
    modelMap.addAttribute("manageTabList", manageTabList);
    addInvites(modelMap, owner);
    return "taboverview";
  }

  /*
   * We going to query and see how many updates and invites this user has
   */
  private void addInvites(ModelMap modelMap, Person owner) {
    // see ${nbrInvites} and ${nbrActivities} in genericpage.tag
    int sharedInvites = inviteService.getCountRecentByInvitee(owner.getId(),
            InviteStatus.OPEN);
    modelMap.addAttribute("nbrInvites", sharedInvites);
  }

}
