/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.control;

import nl.surfnet.coin.portal.domain.Tab;
import nl.surfnet.coin.portal.util.GroupList;
import nl.surfnet.coin.portal.util.OpenSocialModelConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.opensocial.models.Group;
import org.opensocial.models.Person;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

@Controller
public class TeamsController extends BaseController {

  @RequestMapping("/teams.shtml")
  public String teams(ModelMap modelMap, HttpServletRequest request)
          throws InterruptedException, ExecutionException {

    List<Group> groups = getGroupsForLoggedInPerson(request).getGroups();
    modelMap.addAttribute("groups", groups);
    return "teams";
  }

  @RequestMapping(value = "/teams/myteamdetails.shtml", method = RequestMethod.POST)
  public String getTeamMembers(ModelMap modelMap, HttpServletRequest request, @RequestParam String groupId)
          throws Exception {
    String team = groupId;
    if (team.startsWith("GROUPID(")) {
      team = StringUtils.substringBetween(groupId, "GROUPID(", ")");
    }
    final Person owner = getPerson(request);
    final UserId userId = new UserId(UserId.Type.userId, owner.getId());

    final GroupList groupList = getGroupsForLoggedInPerson(request);
    final Group group = groupList.getGroupById(team);

    final List<Person> groupMembers = personService.getPeople(group.getId(), owner.getId());

    modelMap.addAttribute("groupMembers", groupMembers);
    // Get the tabs of the owner
    modelMap.addAttribute("groupTabs", getListOfTabsForOwnerAndTeam(owner, team));
    return "myteamdetails";
  }

  private List<Tab> getListOfTabsForOwnerAndTeam(Person owner, String groupId) {
    List<Tab> allOwnerTabs = tabService.getTabsByOwner(owner.getId());

    List<Tab> tabsForGroup = new ArrayList<Tab>();
    for (Tab ownerTab : allOwnerTabs) {
      if (owner.getId().equals(ownerTab.getOwner()) && groupId.equals(ownerTab.getTeam())) {
        tabsForGroup.add(ownerTab);
      }
    }
    return tabsForGroup;
  }
}