/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.domain;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import nl.surfnet.coin.shared.domain.DomainObject;

/**
 * Represents a tab which can contain gadgets.
 */
@SuppressWarnings("serial")
@MappedSuperclass
public class AbstractTab extends DomainObject {

  @Transient
  public static final String FIXED_TAB_NAME = "SURFconext Info";

  /**
   * User defined name of the tab.
   */
  @NotNull
  @Size(min = 1, max = 25)
  private String name;

  /**
   * Time of creation
   */
  @Column(name = "creation_timestamp")
  private Long creationTimestamp = System.currentTimeMillis();
  
  /**
   * @return the name
   */
  public String getName() {
    return name;
  }

  /**
   * @param name the name to set
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * @return the creationTimestamp
   */
  public Long getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * @param creationTimestamp the creationTimestamp to set
   */
  public void setCreationTimestamp(Long creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
  }
  
  public boolean isFixedTab() {
    return FIXED_TAB_NAME.equalsIgnoreCase(getName());
  } 
  
}
