/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.domain;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

import nl.surfnet.coin.shared.domain.DomainObject;

import org.hibernate.annotations.Proxy;

/**
 * When a tab or gadget gets shared by a user it needs to be deep cloned and
 * this class keeps track of the shared tab or gadget.
 */
@SuppressWarnings("serial")
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="OBJECT_TYPE", discriminatorType=DiscriminatorType.STRING)
@Proxy(lazy = false)
public abstract class SharedResource extends DomainObject {

  /**
   * The set of invites send for this {@link SharedResource}.
   */
  @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy="sharedResource")
  @JoinColumn(name = "shared_resource_id")
  private Set<Invite> invites;

  /**
   * When was this tab shared?
   */
  private Long timestamp;

  /**
   * The person who shared this tab.
   */
  private String sharedBy;
  
  /**
   * The Team Title
   */
  @Column(name = "team_title")
  private String teamTitle;
  
  /**
   * The sharedByDisplayName
   */
  @Column(name = "shared_by_display_name")
  private String sharedByDisplayName;

  /**
   * @return the timestamp
   */
  public Long getTimestamp() {
    return timestamp;
  }

  /**
   * @param timestamp
   *          the timestamp to set
   */
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * @return the sharedBy
   */
  public String getSharedBy() {
    return sharedBy;
  }

  /**
   * @param sharedBy
   *          the sharedBy to set
   */
  public void setSharedBy(String sharedBy) {
    this.sharedBy = sharedBy;
  }
  /**
   * @return the invites
   */
  public Set<Invite> getInvites() {
    return invites;
  }

  /**
   * @param invites
   *          the invites to set
   */
  private void setInvites(Set<Invite> invites) {
    this.invites = invites;
  }
  
  public boolean addInvite(Invite invite) {
    if (this.invites == null) {
      invites = new HashSet<Invite>();
    }
    return invites.add(invite);
  }
  
  /**
   * 
   * @param teamTitle
   */
  public void setTeamTitle(String teamTitle) {
    this.teamTitle = teamTitle;
  }
  
  /**
   * 
   * @param sharedByDisplayName
   */
  public void setSharedByDisplayName(String sharedByDisplayName) {
    this.sharedByDisplayName = sharedByDisplayName;
  }

  /**
   * 
   * @return
   */
  public String getSharedByDisplayName() {
    return sharedByDisplayName;
  }

  /**
   * 
   * @return
   */
  public String getTeamTitle() {
    return teamTitle;
  }

  public abstract SharedResourceType getType();
  
  public abstract String getName();
  
  public abstract String getTeam();

}
