/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package nl.surfnet.coin.portal.domain;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import nl.surfnet.coin.shared.domain.DomainObject;

import org.hibernate.annotations.Type;

/**
 * @author steinwelberg
 *
 */
@SuppressWarnings("serial")
@Entity
@Table (uniqueConstraints = {@UniqueConstraint(columnNames={"field"})})
public class TextContent extends DomainObject {
  
  /*
   * The field for which the text is stored
   */
  private String field;
  
  /*
   * The text
   */
  private String text;

  /**
   * @param field the field to set
   */
  public void setField(String field) {
    this.field = field;
  }

  /**
   * @return the field
   */
  public String getField() {
    return field;
  }

  /**
   * @param text the text to set
   */
  @Type(type="text")
  public void setText(String text) {
    this.text = text;
  }

  /**
   * @return the text
   */
  public String getText() {
    return text;
  }
}
