package nl.surfnet.coin.portal.domain;

import nl.surfnet.coin.shared.domain.DomainObject;
import org.hibernate.annotations.Type;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * The user preferences.
 */
@SuppressWarnings("serial")
@Entity
@Table
public class UserPreferences extends DomainObject {
  /**
   * This property stores the person to whom the preferences belong.
   */
  @Column(name = "person_id", unique = true, nullable = false)
  private String personId;

  /**
   * This property stores whether the user grants gadgets automatically
   * the permissions to share the users information.
   */
  @Column(name = "information_sharing_permission_granted")
  @Type(type = "true_false")
  private Boolean InformationSharingPermissionGranted = false;

  /**
   *
   * @return The ID of the person coupled to these preferences.
   */
  public String getPersonId() {
    return personId;
  }

  /**
   * Set to whom the preferences belong.
   *
   * @param personId ID of the person
   */
  public void setPersonId(final String personId) {
    this.personId = personId;
  }

  /**
   *
   * @return whether the user has granted automatic information sharing
   * permissions for gadgets.
   */
  public Boolean isInformationSharingPermissionGranted() {
    return InformationSharingPermissionGranted;
  }

  /**
   * Set wheter the user has granted automatic information sharing permission
   * for gadgets.
   *
   * @param informationSharingPermissionGranted
   */
  public void setInformationSharingPermissionGranted(final Boolean informationSharingPermissionGranted) {
    this.InformationSharingPermissionGranted = informationSharingPermissionGranted;
  }
}
