/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.model;

import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

/**
 * Simplification of the {@link org.apache.shindig.gadgets.spec.GadgetSpec},
 * just to get a few properties in the Json parser
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class JsonGadgetSpec {
  private String title;
  private String description;
  private String author;
  private String authorEmail;
  private String screenshot;
  private String thumbnail;
  private List<String> errors;

  public String getTitle() {
    return title;
  }

  @SuppressWarnings("unused")
  public void setTitle(String title) {
    this.title = title;
  }

  public String getDescription() {
    return description;
  }

  @SuppressWarnings("unused")
  public void setDescription(String description) {
    this.description = description;
  }

  public String getAuthor() {
    return author;
  }

  @SuppressWarnings("unused")
  public void setAuthor(String author) {
    this.author = author;
  }

  public String getAuthorEmail() {
    return authorEmail;
  }

  @SuppressWarnings("unused")
  public void setAuthorEmail(String authorEmail) {
    this.authorEmail = authorEmail;
  }

  public String getScreenshot() {
    return screenshot;
  }

  @SuppressWarnings("unused")
  public void setScreenshot(String screenshot) {
    this.screenshot = screenshot;
  }

  public String getThumbnail() {
    return thumbnail;
  }

  @SuppressWarnings("unused")
  public void setThumbnail(String thumbnail) {
    this.thumbnail = thumbnail;
  }


  public List<String> getErrors() {
    return errors;
  }

  public void setErrors(List<String> errors) {
    this.errors = errors;
  }

  public boolean containsErrors() {
    return (errors != null && errors.size() > 0);
  }
}
