/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package nl.surfnet.coin.portal.service;

import java.util.List;

import nl.surfnet.coin.portal.domain.Gadget;

/**
 * Can provide metadata about gadgets
 *
 */
public interface MetadataProvider {

  /**
   * 
   * @param gadgets the gadgets where metadata is returned
   * @return the metadata
   */
  String getMetaData(List<Gadget> gadgets) ;
  
}


