package nl.surfnet.coin.portal.service.impl;

import java.util.List;

import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Component;

import nl.surfnet.coin.portal.domain.UserPreferences;
import nl.surfnet.coin.portal.service.UserPreferencesService;
import nl.surfnet.coin.shared.service.GenericServiceHibernateImpl;

@Component("userPreferencesService")
public class UserPreferencesServiceHibernateImpl extends GenericServiceHibernateImpl<UserPreferences>
        implements UserPreferencesService {

  public UserPreferencesServiceHibernateImpl() {
    super(UserPreferences.class);
  }

  /**
   * Fetch the preferences of a person
   *
   * @param personId The person
   * @return The preferences belonging to the person
   */
  @Override
  public UserPreferences getPreferences(final String personId) {
    SimpleExpression personEq = Restrictions.eq("personId", personId);
    List<UserPreferences> preferences = findByCriteria(personEq);
    if (preferences == null || preferences.isEmpty()) {
      final UserPreferences userPreferences = new UserPreferences();
      userPreferences.setPersonId(personId);
      return userPreferences;
    }
    return preferences.get(0);
  }
}
