/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/


package nl.surfnet.coin.portal.util;

import org.opensocial.models.Group;

import java.util.List;


/**
 * @author steinwelberg
 */
public class GroupList {

  private List<Group> groups;

  public GroupList(List<Group> groups) {
    this.groups = groups;
  }

  public void setGroups(List<Group> groups) {
    this.groups = groups;
  }

  public List<Group> getGroups() {
    return groups;
  }

  public List<org.apache.shindig.social.opensocial.model.Group> getShindigGroups() {
    return OpenSocialModelConverter.
            convertOpenSocialGroupListToShindigGroupList(groups);
  }

  public Group getGroupById(String groupId) {
    for (Group group : groups) {
      if (group.getId().equals(groupId)) {
        return group;
      }
    }
    return null;
  }
}
