-- EB tables

DROP TABLE IF EXISTS log_logins;
CREATE TABLE log_logins (
  loginstamp timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL,
  userid varchar(1000) NOT NULL,
  spentityid varchar(1000) DEFAULT NULL,
  idpentityid varchar(1000) DEFAULT NULL,
  spentityname varchar(1000) DEFAULT NULL,
  idpentityname varchar(1000) DEFAULT NULL,
  useragent varchar(1024) DEFAULT NULL,
  voname varchar(1024) DEFAULT NULL,
  id bigint generated by default as identity (start with 20000),
  PRIMARY KEY (id)
);


DROP TABLE IF EXISTS consent;
CREATE TABLE consent (
  consent_date timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL,
  usage_date timestamp DEFAULT '1980-01-01 00:00:00' NOT NULL,
  hashed_user_id varchar(80) NOT NULL,
  service_id varchar(255) NOT NULL,
  attribute varchar(80) NOT NULL,
  PRIMARY KEY (hashed_user_id,service_id)
);



-- SHINDIG tables


DROP TABLE IF EXISTS oauth_token_info;
CREATE TABLE oauth_token_info (
  id varchar(255) NOT NULL,
  access_token varchar(255) DEFAULT NULL,
  token_secret varchar(255) DEFAULT NULL,
  session_handle varchar(255) DEFAULT NULL,
  expires_at bigint DEFAULT NULL,
  app_url varchar(255) DEFAULT NULL,
  module_id varchar(255) DEFAULT NULL,
  service_name varchar(255) DEFAULT NULL,
  token_name varchar(255) DEFAULT NULL,
  user_id varchar(255) DEFAULT NULL,
  PRIMARY KEY (id)
);

INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-19 11:48:41','na', 'https://rave.beta.surfnet.nl', 'http://mock-idp');	
INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-20 11:48:41','na', 'https://rave.beta.surfnet.nl', 'http://mock-idp');	
INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-20 11:48:41','na', 'https://rave.beta.surfnet.nl', 'http://mock-idp');	
INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-21 11:48:41','na', 'https://rave.beta.surfnet.nl', 'http://mock-idp');	
INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-18 11:48:41','na', 'https://canvas.test.surfnet.nl', 'http://mock-idp');	
INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-21 11:48:41','na', 'https://canvas.test.surfnet.nl', 'http://mock-idp');	
INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-21 11:48:41','na', 'https://canvas.test.surfnet.nl', 'http://mock-idp');	
INSERT INTO log_logins (loginstamp, userid, spentityname, idpentityid) 
	VALUES ('2012-04-22 11:48:41','na', 'https://canvas.test.surfnet.nl', 'http://mock-idp');	
