drop table if exists ss_actions;
create table ss_actions (
  id bigint generated by default as identity (start with 1),
  jiraKey varchar(255),
  institutionId varchar(255),
  userId varchar(1024),
  userName varchar(1024),
  actionType varchar(255),
  actionStatus varchar(255),
  body varchar(4096),
  idp varchar(255),
  sp varchar(255),
  requestDate timestamp default 'now',
  primary key (id)
);

drop table if exists oauth_entry;
create table oauth_entry (
  token varchar(255) NOT NULL,
  token_secret varchar(255) DEFAULT NULL,
  app_id varchar(255) DEFAULT NULL,
  callback_url varchar(1024) DEFAULT NULL,
  callback_url_signed boolean DEFAULT NULL,
  user_id varchar(255) DEFAULT NULL,
  authorized boolean DEFAULT NULL,
  consumer_key varchar(255) DEFAULT NULL,
  type varchar(255) DEFAULT NULL,
  issue_time datetime DEFAULT NULL,
  domain varchar(255) DEFAULT NULL,
  container varchar(255) DEFAULT NULL,
  oauth_version varchar(255) DEFAULT NULL,
  callback_token varchar(255) DEFAULT NULL,
  callback_token_attempts integer DEFAULT NULL,
  virtual_organization varchar(255) DEFAULT NULL,
  PRIMARY KEY (token)
);

INSERT INTO oauth_entry (token, token_secret, app_id, callback_url, callback_url_signed, user_id, authorized, consumer_key, type, issue_time, domain, container, oauth_version, callback_token, callback_token_attempts, virtual_organization)
VALUES
  ('cafebabe-babe-cafe-babe-cafebabecafe', 'deadbeef-dead-beef-dead-beefdeadbeef', 'http://mujina-sp', 'https://mujina-sp.example.com/social/oauth-callback.shtml', 1, 'urn:collab:person:example.com:test-user', 1, 'http://mujina-sp', 'ACCESS', '2012-06-14 11:54:32', 'surfnet.nl', NULL, '1.0', '654321', 0, NULL);

INSERT INTO oauth_entry (token, token_secret, app_id, callback_url, callback_url_signed, user_id, authorized, consumer_key, type, issue_time, domain, container, oauth_version, callback_token, callback_token_attempts, virtual_organization)
VALUES
  ('deadbeef-dead-beef-dead-beefdeadbeef', 'deadbeef-dead-beef-dead-beefdeadbeef', 'http://mujina-sp-2', 'https://mujina-sp2.example.com/social/oauth-callback.shtml', 1, 'urn:collab:person:example.com:test-user', 1, 'http://mujina-sp-2', 'ACCESS', '2012-06-14 11:54:32', 'surfnet.nl', NULL, '1.0', '123456', 0, NULL);

INSERT INTO oauth_entry (token, token_secret, app_id, callback_url, callback_url_signed, user_id, authorized, consumer_key, type, issue_time, domain, container, oauth_version, callback_token, callback_token_attempts, virtual_organization)
VALUES
  ('babecafe-babe-cafe-babe-cafebabecafe', 'deadbeef-dead-beef-dead-beefdeadbeef', 'http://mujina-sp', 'https://mujina-sp.example.com/social/oauth-callback.shtml', 1, 'urn:collab:person:example.com:dummy-user', 1, 'http://mujina-sp', 'ACCESS', '2012-06-14 11:54:32', 'surfnet.nl', NULL, '1.0', '987654', 0, NULL);

INSERT INTO oauth_entry (token, token_secret, app_id, callback_url, callback_url_signed, user_id, authorized, consumer_key, type, issue_time, domain, container, oauth_version, callback_token, callback_token_attempts, virtual_organization)
VALUES
  ('babecafe-cafe-babe-babe-cafebabecafe', 'deadbeef-dead-beef-dead-beefdeadbeef', 'http://mujina-sp-1082', 'https://mujina-sp.example.com/social/oauth-callback.shtml', 1, 'admin', 1, 'http://mujina-sp-1082', 'ACCESS', '2012-06-14 11:54:32', 'surfnet.nl', NULL, '1.0', '987654', 0, NULL);

drop table if exists oauth_access_token;
CREATE TABLE oauth_access_token (
  token_id varchar(255) NOT NULL,
  token LONGVARBINARY,
  authentication_id varchar(255) DEFAULT NULL,
  user_name varchar(255) DEFAULT NULL,
  client_id varchar(255) DEFAULT NULL,
  client_entity_id varchar(1000) DEFAULT NULL,
  authentication LONGVARBINARY,
  refresh_token varchar(255) DEFAULT NULL,
  PRIMARY KEY (token_id)
);

INSERT INTO oauth_access_token (token_id, token, authentication_id, user_name, client_id, client_entity_id, authentication, refresh_token)
VALUES
  ('c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0',
  'ACED0005737200436F72672E737072696E676672616D65776F726B2E73656375726974792E6F61757468322E636F6D6D6F6E2E44656661756C744F4175746832416363657373546F6B656E0CB29E361B24FACE0200064C00156164646974696F6E616C496E666F726D6174696F6E74000F4C6A6176612F7574696C2F4D61703B4C000A65787069726174696F6E7400104C6A6176612F7574696C2F446174653B4C000C72656672657368546F6B656E74003F4C6F72672F737072696E676672616D65776F726B2F73656375726974792F6F61757468322F636F6D6D6F6E2F4F417574683252656672657368546F6B656E3B4C000573636F706574000F4C6A6176612F7574696C2F5365743B4C0009746F6B656E547970657400124C6A6176612F6C616E672F537472696E673B4C000576616C756571007E000578707372001E6A6176612E7574696C2E436F6C6C656374696F6E7324456D7074794D6170593614855ADCE7D002000078707372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001382F9A00CE7870737200256A6176612E7574696C2E436F6C6C656374696F6E7324556E6D6F6469666961626C65536574801D92D18F9B80550200007872002C6A6176612E7574696C2E436F6C6C656374696F6E7324556E6D6F6469666961626C65436F6C6C656374696F6E19420080CB5EF71E0200014C0001637400164C6A6176612F7574696C2F436F6C6C656374696F6E3B7870737200116A6176612E7574696C2E48617368536574BA44859596B8B7340300007870770C000000103F40000000000001740004726561647874000662656172657274002464313632356561372D663331342D343838612D616662372D643165666136393665303065',
  '0123456a0485d542352ada314771aabb',
  'urn:collab:person:example.edu:john.doe',
  'https://mujina-sp.example.com/',
  'https://mujina-sp.example.com',
  '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',
  NULL);
INSERT INTO oauth_access_token (token_id, token, authentication_id, user_name, client_id, client_entity_id, authentication, refresh_token)
VALUES
  ('deadbeef-dead-beef-dead-beefdeadbeef',
  'ACED0005737200436F72672E737072696E676672616D65776F726B2E73656375726974792E6F61757468322E636F6D6D6F6E2E44656661756C744F4175746832416363657373546F6B656E0CB29E361B24FACE0200064C00156164646974696F6E616C496E666F726D6174696F6E74000F4C6A6176612F7574696C2F4D61703B4C000A65787069726174696F6E7400104C6A6176612F7574696C2F446174653B4C000C72656672657368546F6B656E74003F4C6F72672F737072696E676672616D65776F726B2F73656375726974792F6F61757468322F636F6D6D6F6E2F4F417574683252656672657368546F6B656E3B4C000573636F706574000F4C6A6176612F7574696C2F5365743B4C0009746F6B656E547970657400124C6A6176612F6C616E672F537472696E673B4C000576616C756571007E000578707372001E6A6176612E7574696C2E436F6C6C656374696F6E7324456D7074794D6170593614855ADCE7D002000078707372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001382F9A00CE7870737200256A6176612E7574696C2E436F6C6C656374696F6E7324556E6D6F6469666961626C65536574801D92D18F9B80550200007872002C6A6176612E7574696C2E436F6C6C656374696F6E7324556E6D6F6469666961626C65436F6C6C656374696F6E19420080CB5EF71E0200014C0001637400164C6A6176612F7574696C2F436F6C6C656374696F6E3B7870737200116A6176612E7574696C2E48617368536574BA44859596B8B7340300007870770C000000103F40000000000001740004726561647874000662656172657274002464313632356561372D663331342D343838612D616662372D643165666136393665303065',
  '7654321a0485d542352ada314771bbaa',
  'urn:collab:person:example.edu:john.doe',
  'https://mujina-sp.example.edu/',
  'https://mujina-sp.example.edu',
  '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',
  NULL);
INSERT INTO oauth_access_token (token_id, token, authentication_id, user_name, client_id, client_entity_id, authentication, refresh_token)
VALUES
  ('babecafe-babe-cafe-babe-cafebabecafe',
  'ACED0005737200436F72672E737072696E676672616D65776F726B2E73656375726974792E6F61757468322E636F6D6D6F6E2E44656661756C744F4175746832416363657373546F6B656E0CB29E361B24FACE0200064C00156164646974696F6E616C496E666F726D6174696F6E74000F4C6A6176612F7574696C2F4D61703B4C000A65787069726174696F6E7400104C6A6176612F7574696C2F446174653B4C000C72656672657368546F6B656E74003F4C6F72672F737072696E676672616D65776F726B2F73656375726974792F6F61757468322F636F6D6D6F6E2F4F417574683252656672657368546F6B656E3B4C000573636F706574000F4C6A6176612F7574696C2F5365743B4C0009746F6B656E547970657400124C6A6176612F6C616E672F537472696E673B4C000576616C756571007E000578707372001E6A6176612E7574696C2E436F6C6C656374696F6E7324456D7074794D6170593614855ADCE7D002000078707372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001382F9A00CE7870737200256A6176612E7574696C2E436F6C6C656374696F6E7324556E6D6F6469666961626C65536574801D92D18F9B80550200007872002C6A6176612E7574696C2E436F6C6C656374696F6E7324556E6D6F6469666961626C65436F6C6C656374696F6E19420080CB5EF71E0200014C0001637400164C6A6176612F7574696C2F436F6C6C656374696F6E3B7870737200116A6176612E7574696C2E48617368536574BA44859596B8B7340300007870770C000000103F40000000000001740004726561647874000662656172657274002464313632356561372D663331342D343838612D616662372D643165666136393665303065',
  '1234567a0485d542352ada314771abcd',
  'urn:collab:person:test.surfguest.nl:jjoachimsthal',
  'http://local-selfservice/test',
  'http://local-selfservice',
  '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',
  NULL);

drop table if exists oauth1_tokens;
CREATE TABLE oauth1_tokens (
  token varchar(255) NOT NULL,
  callbackUrl varchar(255),
  verifier varchar(255),
  secret varchar(255) NOT NULL,
  consumerKey varchar(255) NOT NULL,
  userId varchar(1000) DEFAULT NULL,
  isAccessToken boolean NOT NULL,
  tokenTimestamp bigint DEFAULT NULL,
  userAuthentication LONGVARBINARY,
  PRIMARY KEY (token)
);

INSERT INTO oauth1_tokens (token, callbackUrl, verifier, secret, consumerKey, userId, isAccessToken, tokenTimestamp, userAuthentication)
VALUES
  ('cafebabe-29ff-4a96-822b-9662bdefeeee',
  NULL, NULL, 
  'x0unwK2ZLoZqCzD7mJ+/HxyqKTwlOLKaXHRVgb6O++E74fRayBXQ5dEkWxN6IdpgbWsp+uKFZ0uVO2MTWzTL8qIZw7PClY32pe3YUhBdPrQ=', 
  'https://mujina-sp.example.com',
  'urn:collab:person:example.edu:john.doe', 1, 1340800852829,
  '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');

INSERT INTO oauth1_tokens (token, callbackUrl, verifier, secret, consumerKey, userId, isAccessToken, tokenTimestamp, userAuthentication)
VALUES
  ('babecafe-29ff-4a96-822b-9662bdefeeee',
  NULL, NULL,
  'x0unwK2ZLoZqCzD7mJ+/HxyqKTwlOLKaXHRVgb6O++E74fRayBXQ5dEkWxN6IdpgbWsp+uKFZ0uVO2MTWzTL8qIZw7PClY32pe3YUhBdPrQ=',
  'http://local-selfservice',
  'urn:collab:person:test.surfguest.nl:jjoachimsthal', 1, 1340800852829,
  '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');
