/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.rest;

import com.google.common.collect.Collections2;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import selfservice.api.rest.GsonHttpMessageConverter;
import selfservice.domain.CoinUser;
import selfservice.domain.Service;
import selfservice.util.AttributeMapFilter;

public class EnrichJson {
    private static final Logger logger = LoggerFactory.getLogger(EnrichJson.class);
    public static final String FILTERED_USER_ATTRIBUTES = "filteredUserAttributes";
    public static final String SUPER_USER = "superUser";
    public static final String DASHBOARD_ADMIN = "dashboardAdmin";
    public static final String STATS_URL = "statsUrl";
    private Map<Class<?>, JsonApplier> mapping = new HashMap();
    private final CoinUser currentUser;
    private JsonElement json;

    private EnrichJson(CoinUser coinUser, final String statsUrl) {
        logger.debug("Using {} for user {}", (Object)statsUrl, (Object)coinUser.getDisplayName());
        this.currentUser = coinUser;
        final Gson gson = GsonHttpMessageConverter.GSON_BUILDER.create();
        this.mapping.put(CoinUser.class, new JsonApplier(){

            @Override
            public void apply(JsonElement coinUserJsonElement, Object payload) {
                JsonObject coinUser = coinUserJsonElement.getAsJsonObject();
                coinUser.addProperty(EnrichJson.SUPER_USER, Boolean.valueOf(((CoinUser)payload).isSuperUser()));
                coinUser.addProperty(EnrichJson.DASHBOARD_ADMIN, Boolean.valueOf(((CoinUser)payload).isDashboardAdmin()));
                coinUser.addProperty(EnrichJson.STATS_URL, statsUrl);
            }
        });
        this.mapping.put(Service.class, new JsonApplier(){

            @Override
            public void apply(JsonElement serviceJsonElement, Object payload) {
                Service service = (Service)payload;
                JsonArray filteredUserAttributes = new JsonArray();
                if (service.getArp() != null && !service.getArp().isNoArp() && !service.getArp().isNoAttrArp()) {
                    Collection jsonElements = Collections2.transform(AttributeMapFilter.filterAttributes(service.getArp().getAttributes(), EnrichJson.this.currentUser.getAttributeMap()), input -> gson.toJsonTree(input));
                    for (JsonElement jsonElement : jsonElements) {
                        filteredUserAttributes.add(jsonElement);
                    }
                }
                JsonObject serviceAsJsonObject = serviceJsonElement.getAsJsonObject();
                serviceAsJsonObject.add(EnrichJson.FILTERED_USER_ATTRIBUTES, (JsonElement)filteredUserAttributes);
            }
        });
    }

    public EnrichJson json(JsonElement json) {
        this.json = json;
        return this;
    }

    public static EnrichJson forUser(CoinUser currentUser, String statsUrl) {
        return new EnrichJson(currentUser, statsUrl);
    }

    public void forPayload(Object payload) {
        JsonElement payloadAsJsonElement = this.json.getAsJsonObject().get("payload");
        if (payloadAsJsonElement.isJsonObject()) {
            if (this.mapping.containsKey(payload.getClass())) {
                this.mapping.get(payload.getClass()).apply(payloadAsJsonElement, payload);
            }
        } else if (!payloadAsJsonElement.isJsonPrimitive()) {
            JsonArray jsonArray = payloadAsJsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Class<?> classOfPayloadElement = ((List)payload).get(i).getClass();
                if (!this.mapping.containsKey(classOfPayloadElement)) continue;
                this.mapping.get(classOfPayloadElement).apply(jsonArray.get(i), ((List)payload).get(i));
            }
        }
    }

    private static interface JsonApplier {
        public void apply(JsonElement var1, Object var2);
    }
}

