/*
 * Decompiled with CFR 0.152.
 */
package selfservice.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import selfservice.domain.Action;
import selfservice.domain.Category;
import selfservice.domain.CategoryValue;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.domain.JiraTask;
import selfservice.domain.LicenseContactPerson;
import selfservice.domain.Service;
import selfservice.domain.Taxonomy;
import selfservice.service.Csa;

public class CsaMock
implements Csa {
    private ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private List<Action> actionsCreated = new ArrayList<Action>();

    private List<Service> getServices() {
        List services = (List)this.parseJsonData((TypeReference)new TypeReference<List<Service>>(){}, "csa-json/protected-services.json");
        return this.restoreCategoryReferences(services);
    }

    @Override
    public List<Service> getServicesForIdp(String idpEntityId) {
        return this.getServices();
    }

    @Override
    public Service getServiceForIdp(String idpEntityId, long serviceId) {
        List<Service> services = this.getServicesForIdp(idpEntityId);
        for (Service s : services) {
            if (s.getId() != serviceId) continue;
            return s;
        }
        return null;
    }

    @Override
    public Taxonomy getTaxonomy() {
        Taxonomy taxonomy = (Taxonomy)this.parseJsonData((TypeReference)new TypeReference<Taxonomy>(){}, "csa-json/taxonomy_" + this.getLocale() + ".json");
        List<Category> categories = taxonomy.getCategories();
        for (Category category : categories) {
            List<CategoryValue> values = category.getValues();
            for (CategoryValue value : values) {
                value.setCategory(category);
            }
        }
        return taxonomy;
    }

    @Override
    public List<Action> getJiraActions(String idpEntityId) {
        List actions = (List)this.parseJsonData((TypeReference)new TypeReference<List<Action>>(){}, "csa-json/actions.json");
        actions.addAll(this.actionsCreated);
        return actions;
    }

    @Override
    public Action createAction(Action action) {
        action.setStatus(JiraTask.Status.OPEN);
        action.setJiraKey("TEST-" + System.currentTimeMillis());
        action.setId(System.currentTimeMillis());
        action.setIdpName("Mock IdP");
        action.setSpName("Mock SP");
        this.actionsCreated.add(action);
        return action;
    }

    @Override
    public List<LicenseContactPerson> licenseContactPersons(String idpEntityId) {
        if (idpEntityId.equals("http://mock-idp")) {
            return (List)this.parseJsonData((TypeReference)new TypeReference<List<LicenseContactPerson>>(){}, "csa-json/license-contact-persons.json");
        }
        return new ArrayList<LicenseContactPerson>();
    }

    @Override
    public List<InstitutionIdentityProvider> getInstitutionIdentityProviders(String identityProviderId) {
        if (identityProviderId.endsWith("-3") || identityProviderId.endsWith("-4")) {
            return (List)this.parseJsonData((TypeReference)new TypeReference<List<InstitutionIdentityProvider>>(){}, "csa-json/institution-identity-providers-2.json");
        }
        return (List)this.parseJsonData((TypeReference)new TypeReference<List<InstitutionIdentityProvider>>(){}, "csa-json/institution-identity-providers.json");
    }

    @Override
    public List<InstitutionIdentityProvider> getAllInstitutionIdentityProviders() {
        return (List)this.parseJsonData((TypeReference)new TypeReference<List<InstitutionIdentityProvider>>(){}, "csa-json/all-institution-identity-providers.json");
    }

    @Override
    public List<InstitutionIdentityProvider> serviceUsedBy(String spEntityId) {
        if (spEntityId.equals("https://bod.dummy.sp")) {
            return new ArrayList<InstitutionIdentityProvider>();
        }
        return this.getAllInstitutionIdentityProviders();
    }

    public Object parseJsonData(TypeReference typeReference, String jsonFile) {
        try {
            return this.objectMapper.readValue(new ClassPathResource(jsonFile).getInputStream(), typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Service> restoreCategoryReferences(List<Service> services) {
        for (Service service : services) {
            service.restoreCategoryReferences();
        }
        return services;
    }

    private String getLocale() {
        HttpServletRequest request;
        Locale locale = null;
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sra != null && (request = sra.getRequest()) != null) {
            locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        }
        return locale != null ? locale.getLanguage() : "en";
    }
}

