/*
 * Decompiled with CFR 0.152.
 */
package selfservice.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import selfservice.domain.Group;
import selfservice.service.VootClient;

public class VootClientImpl
implements VootClient {
    private static final Logger LOG = LoggerFactory.getLogger(VootClientImpl.class);
    private String accessTokenUri;
    private String clientId;
    private String clientSecret;
    private String spaceDelimitedScopes;
    private String serviceUrl;
    private OAuth2RestTemplate vootService;

    public VootClientImpl(String accessTokenUri, String clientId, String clientSecret, String spaceDelimitedScopes, String serviceUrl) {
        this.accessTokenUri = accessTokenUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.spaceDelimitedScopes = spaceDelimitedScopes;
        this.serviceUrl = serviceUrl;
        this.vootService = new OAuth2RestTemplate(this.vootConfiguration());
    }

    private OAuth2ProtectedResourceDetails vootConfiguration() {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        LOG.debug("clientId: {}", (Object)this.clientId);
        details.setId("dashboard");
        details.setClientId(this.clientId);
        details.setClientSecret(this.clientSecret);
        details.setAccessTokenUri(this.accessTokenUri);
        details.setScope(Arrays.asList(this.spaceDelimitedScopes.split(" ")));
        return details;
    }

    @Override
    public List<Group> groups(String userId) {
        List maps = (List)this.vootService.getForObject(this.serviceUrl + "/internal/groups/{userId}", List.class, new Object[]{userId});
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Map map : maps) {
            groups.add(new Group((String)map.get("id")));
        }
        LOG.debug("Retrieved groups: {}", groups);
        return groups;
    }
}

