/*
 * Decompiled with CFR 0.152.
 */
package selfservice.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.GenericFilterBean;
import selfservice.domain.CoinAuthentication;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.Group;
import selfservice.service.VootClient;
import selfservice.util.SpringSecurity;

public class VootFilter
extends GenericFilterBean {
    public static final String SESSION_KEY_GROUP_ACCESS = "SESSION_KEY_GROUP_ACCESS";
    private final Logger LOG = LoggerFactory.getLogger(VootFilter.class);
    private VootClient vootClient;
    private String dashboardAdmin;
    private String dashboardViewer;
    private String dashboardSuperUser;

    public VootFilter(VootClient vootClient, String dashboardAdmin, String dashboardViewer, String dashboardSuperUser) {
        this.vootClient = vootClient;
        this.dashboardAdmin = dashboardAdmin;
        this.dashboardViewer = dashboardViewer;
        this.dashboardSuperUser = dashboardSuperUser;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(true);
        if (SpringSecurity.isFullyAuthenticated()) {
            CoinUser user = SpringSecurity.getCurrentUser();
            List<Group> groups = (List<Group>)session.getAttribute(SESSION_KEY_GROUP_ACCESS);
            if (CollectionUtils.isEmpty((Collection)groups)) {
                groups = this.vootClient.groups(user.getUid());
                session.setAttribute(SESSION_KEY_GROUP_ACCESS, groups);
            }
            this.elevateUser(user, groups);
        }
        chain.doFilter(request, response);
    }

    private void elevateUser(CoinUser coinUser, List<Group> groups) {
        this.LOG.debug("Memberships of adminTeams '{}' for user '{}'", groups, (Object)coinUser.getUid());
        coinUser.setAuthorities(new HashSet<CoinAuthority>());
        if (this.groupsContains(this.dashboardAdmin, groups)) {
            coinUser.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
        } else if (this.groupsContains(this.dashboardViewer, groups)) {
            coinUser.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
        } else if (this.groupsContains(this.dashboardSuperUser, groups)) {
            coinUser.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER));
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)new CoinAuthentication(coinUser));
    }

    private boolean groupsContains(String teamId, List<Group> groups) {
        return groups.stream().anyMatch(group -> teamId.equalsIgnoreCase(group.getId()));
    }
}

