/*
 * Decompiled with CFR 0.152.
 */
package selfservice.sab;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import selfservice.sab.Sab;
import selfservice.sab.SabPerson;
import selfservice.sab.SabResponseParser;
import selfservice.sab.SabRole;
import selfservice.sab.SabRoleHolder;
import selfservice.sab.SabTransport;

public class SabClient
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClient.class);
    private static final String REQUEST_TEMPLATE_LOCATION = "/sab-request.xml";
    protected static final DateTimeFormatter XML_DATE_TIME_FORMAT = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SabTransport sabTransport;
    private SabResponseParser sabResponseParser;

    public SabClient(SabTransport sabTransport) {
        this.sabTransport = sabTransport;
        this.sabResponseParser = new SabResponseParser();
    }

    @Override
    public SabRoleHolder getRoles(String userId) throws IOException {
        String messageId = UUID.randomUUID().toString();
        String request = this.createRequest(userId, messageId);
        return this.sabResponseParser.parse(this.sabTransport.getResponse(request));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<SabPerson> getPersonsInRoleForOrganization(String organisationAbbreviation, String role) {
        try (InputStream inputStream = this.sabTransport.getRestResponse(organisationAbbreviation, role);){
            List profiles = (List)((HashMap)this.objectMapper.readValue(inputStream, HashMap.class)).get("profiles");
            Collection collection = profiles.stream().map(profile -> {
                List<SabRole> sabRoles = ((List)profile.get("authorisations")).stream().map(authorisation -> new SabRole((String)authorisation.get("short"), (String)authorisation.get("role"))).collect(Collectors.toList());
                return new SabPerson((String)profile.get("firstname"), (String)profile.get("surname"), (String)profile.get("uid"), sabRoles);
            }).filter(p -> p.hasRole(role)).collect(Collectors.toList());
            return collection;
        }
        catch (IOException | RuntimeException e) {
            LOG.warn("Could not retrieve SAB info");
            return Collections.emptyList();
        }
    }

    public String createRequest(String userId, String messageId) {
        String template;
        try {
            template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(REQUEST_TEMPLATE_LOCATION), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String issueInstant = XML_DATE_TIME_FORMAT.print(new Date().getTime());
        return MessageFormat.format(template, messageId, issueInstant, userId);
    }
}

