/*
 * Decompiled with CFR 0.152.
 */
package selfservice.sab;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import selfservice.sab.Sab;
import selfservice.sab.SabPerson;
import selfservice.sab.SabRole;
import selfservice.sab.SabRoleHolder;

public class SabClientMock
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClientMock.class);
    private static final SabRole ROLE_BEHEERDER = new SabRole("CONBEH", "SURFconextbeheerder");
    private static final SabRole ROLE_VERANTWOORDELIJKE = new SabRole("CONVER", "SURFconextverantwoordelijke");
    private final List<SabPerson> sabPersons = Arrays.asList(new SabPerson("Hans", "Janssen", "hjanssen", Arrays.asList(ROLE_BEHEERDER)), new SabPerson("Frans", "Franssen", "ffransen", Arrays.asList(ROLE_BEHEERDER, ROLE_VERANTWOORDELIJKE)));
    private Map<String, SabRoleHolder> rolesMapping = new ConcurrentHashMap<String, SabRoleHolder>();

    public SabClientMock() {
        this.rolesMapping.put("user1", new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Bar")));
        this.rolesMapping.put("user2", new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Baz")));
        this.rolesMapping.put("noroles", new SabRoleHolder("SURFNET", Collections.emptyList()));
    }

    @Override
    public SabRoleHolder getRoles(String userId) throws IOException {
        SabRoleHolder sabRoleHolder = this.rolesMapping.get(userId);
        LOG.debug("Returning SAB role holder: {}", (Object)sabRoleHolder);
        return sabRoleHolder;
    }

    @Override
    public Collection<SabPerson> getPersonsInRoleForOrganization(String organisationAbbreviation, String role) {
        ArrayList<SabPerson> result = new ArrayList<SabPerson>();
        for (SabPerson sabPerson : this.sabPersons) {
            Collection roleNames = Collections2.transform(sabPerson.getRoles(), r -> r.roleName);
            if (!roleNames.contains(role)) continue;
            result.add(sabPerson);
        }
        return result;
    }
}

