/*
 * Decompiled with CFR 0.152.
 */
package selfservice.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.service.Csa;

public class SpringSecurity {
    private static InstitutionIdentityProvider impersonatedIdentityProvider;

    public static CoinUser getCurrentUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return new CoinUser();
        }
        Object principal = auth.getPrincipal();
        if (principal != null && principal instanceof CoinUser) {
            return (CoinUser)principal;
        }
        return new CoinUser();
    }

    public static boolean isFullyAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof CoinUser;
    }

    public static InstitutionIdentityProvider getImpersonatedIdentityProvider() {
        return impersonatedIdentityProvider;
    }

    public static void setImpersonatedIdentityProvider(InstitutionIdentityProvider impersonatedIdentityProvider) {
        SpringSecurity.impersonatedIdentityProvider = impersonatedIdentityProvider;
    }

    public static void ensureAccess(Csa csa, String idpId) {
        SpringSecurity.validateIdp(SpringSecurity.getIdpFromId(csa, idpId));
    }

    public static void setSwitchedToIdp(Csa csa, String idpId, String role) {
        InstitutionIdentityProvider idp = idpId != null ? SpringSecurity.validateIdp(SpringSecurity.getIdpFromId(csa, idpId)) : null;
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (idp == null) {
            currentUser.setAuthorities(new HashSet<CoinAuthority>(Collections.singleton(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER))));
        } else if (!role.isEmpty()) {
            currentUser.addAuthority(new CoinAuthority(CoinAuthority.Authority.valueOf(role)));
        }
        SpringSecurity.getCurrentUser().setSwitchedToIdp(idp);
    }

    public static InstitutionIdentityProvider validateIdp(InstitutionIdentityProvider idp) {
        if (SpringSecurity.getCurrentUser().isSuperUser()) {
            return idp;
        }
        Optional<InstitutionIdentityProvider> currentInstitutionIdentityProvider = SpringSecurity.getCurrentUser().getInstitutionIdps().stream().filter(provider -> provider.getId().equals(idp.getId())).findFirst();
        return currentInstitutionIdentityProvider.orElseThrow(() -> new SecurityException(idp.getId() + " is unknown for " + SpringSecurity.getCurrentUser().getUsername()));
    }

    public static InstitutionIdentityProvider getIdpFromId(Csa csa, String idp) {
        List<InstitutionIdentityProvider> idps = csa.getAllInstitutionIdentityProviders();
        for (InstitutionIdentityProvider identityProvider : idps) {
            if (!identityProvider.getId().equalsIgnoreCase(idp)) continue;
            return identityProvider;
        }
        throw new SecurityException(idp + " does not exist");
    }
}

