/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.rest;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import selfservice.api.rest.EnrichJson;
import selfservice.api.rest.ExcludeJsonIgnore;
import selfservice.api.rest.RestResponse;
import selfservice.util.SpringSecurity;

public class GsonHttpMessageConverter
extends AbstractHttpMessageConverter<RestResponse> {
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExcludeJsonIgnore()});
    private Gson gson = GSON_BUILDER.create();
    private String statsBaseUrl;
    private String statsClientId;
    private String statsScope;
    private String statsRedirectUri;

    public GsonHttpMessageConverter(String statsBaseUr, String statsClientId, String statsScope, String statsRedirectUri) {
        this.statsBaseUrl = statsBaseUr;
        this.statsClientId = statsClientId;
        this.statsScope = statsScope;
        this.statsRedirectUri = statsRedirectUri;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return clazz.isAssignableFrom(RestResponse.class) && mediaType.equals((Object)MediaType.APPLICATION_JSON);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Arrays.asList(MediaType.APPLICATION_JSON);
    }

    protected boolean supports(Class<?> clazz) {
        return false;
    }

    protected RestResponse readInternal(Class<? extends RestResponse> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException("nyi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInternal(RestResponse objectRestResponse, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonElement json = this.gson.toJsonTree((Object)objectRestResponse);
        EnrichJson.forUser(SpringSecurity.getCurrentUser(), String.format("%s/oauth/authorize.php?response_type=token&client_id=%s&scope=%s&redirect_uri=%s", this.statsBaseUrl, this.statsClientId, this.statsScope, this.statsRedirectUri)).json(json).forPayload(objectRestResponse.getPayload());
        JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter(outputMessage.getBody(), "UTF-8"));
        try {
            this.gson.toJson(json, jsonWriter);
        }
        finally {
            jsonWriter.flush();
        }
    }

    public void setStatsBaseUrl(String statsBaseUrl) {
        this.statsBaseUrl = statsBaseUrl;
    }

    public void setStatsClientId(String statsClientId) {
        this.statsClientId = statsClientId;
    }

    public void setStatsScope(String statsScope) {
        this.statsScope = statsScope;
    }

    public void setStatsRedirectUri(String statsRedirectUri) {
        this.statsRedirectUri = statsRedirectUri;
    }
}

