/*
 * Decompiled with CFR 0.152.
 */
package selfservice.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;
import selfservice.domain.CoinAuthentication;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.sab.Sab;
import selfservice.sab.SabRoleHolder;
import selfservice.util.SpringSecurity;

public class SabEntitlementsFilter
extends GenericFilterBean {
    private static final Logger LOG = LoggerFactory.getLogger(SabEntitlementsFilter.class);
    protected static final String PROCESSED = "nl.surfnet.coin.selfservice.filter.SabEntitlementsFilter.PROCESSED";
    private final Sab sab;
    private final String adminSurfConextIdpRole;
    private final String viewerSurfConextIdpRole;

    public SabEntitlementsFilter(Sab sab, String adminSurfConextIdpRole, String viewerSurfConextIdpRole) {
        this.sab = sab;
        this.adminSurfConextIdpRole = adminSurfConextIdpRole;
        this.viewerSurfConextIdpRole = viewerSurfConextIdpRole;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(true);
        if (SpringSecurity.isFullyAuthenticated() && session.getAttribute(PROCESSED) == null) {
            CoinUser user = SpringSecurity.getCurrentUser();
            try {
                SabRoleHolder roleHolder = this.sab.getRoles(user.getUid());
                if (roleHolder == null) {
                    LOG.debug("SAB returned no information about user '{}'. Will skip SAB entitlement.", (Object)user.getUid());
                    session.setAttribute(PROCESSED, (Object)"true");
                } else {
                    LOG.debug("Roles of user '{}' in organisation {}: {}", new Object[]{user.getUid(), roleHolder.getOrganisation(), roleHolder.getRoles()});
                    this.elevateUserIfApplicable(user, roleHolder);
                    session.setAttribute(PROCESSED, (Object)"true");
                    LOG.debug("Authorities of user '{}' after processing SAB entitlements: {}", (Object)user.getUid(), user.getAuthorityEnums());
                    SecurityContextHolder.getContext().setAuthentication((Authentication)new CoinAuthentication(user));
                }
            }
            catch (IOException e) {
                LOG.warn("Skipping SAB entitlement, SAB request got IOException: {}", (Object)e.getMessage());
            }
        }
        chain.doFilter(request, response);
    }

    private void elevateUserIfApplicable(CoinUser user, SabRoleHolder roleHolder) {
        if (this.needToAddRole(roleHolder, this.adminSurfConextIdpRole)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
        } else if (this.needToAddRole(roleHolder, this.viewerSurfConextIdpRole)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
        }
    }

    private boolean needToAddRole(SabRoleHolder roleHolder, String adminLicentieIdPRole) {
        return StringUtils.hasText((String)adminLicentieIdPRole) && roleHolder.getRoles().contains(adminLicentieIdPRole);
    }
}

