/*
 * Decompiled with CFR 0.152.
 */
package selfservice;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.TraceRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceWebFilterAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.web.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import selfservice.api.rest.GsonHttpMessageConverter;
import selfservice.sab.HttpClientTransport;
import selfservice.sab.Sab;
import selfservice.sab.SabClient;
import selfservice.sab.SabClientMock;
import selfservice.service.Csa;
import selfservice.service.VootClient;
import selfservice.service.impl.CsaImpl;
import selfservice.service.impl.CsaMock;
import selfservice.service.impl.VootClientImpl;
import selfservice.service.impl.VootClientMock;
import selfservice.util.CookieThenAcceptHeaderLocaleResolver;

@SpringBootApplication
@EnableAutoConfiguration(exclude={SecurityAutoConfiguration.class, FreeMarkerAutoConfiguration.class, TraceWebFilterAutoConfiguration.class, TraceRepositoryAutoConfiguration.class})
public class Application
extends SpringBootServletInitializer {
    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class});
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public LocaleResolver localeResolver() {
        CookieThenAcceptHeaderLocaleResolver localeResolver = new CookieThenAcceptHeaderLocaleResolver();
        localeResolver.setCookieName("dashboardLang");
        localeResolver.setDefaultLocale(new Locale("nl"));
        localeResolver.setCookieMaxAge(315360000);
        return localeResolver;
    }

    @Bean
    public WebMvcConfigurerAdapter webMvcConfigurerAdapter(final @Value(value="${statsBaseUrl}") String statsBaseUrl, final @Value(value="${statsClientId}") String statsClientId, final @Value(value="${statsScope}") String statsScope, final @Value(value="${statsRedirectUri}") String statsRedirectUri) {
        return new WebMvcConfigurerAdapter(){

            public void addInterceptors(InterceptorRegistry registry) {
                LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
                localeChangeInterceptor.setParamName("lang");
                registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
                registry.addInterceptor((HandlerInterceptor)new HandlerInterceptorAdapter(){

                    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                        response.addHeader("sessionAlive", "success");
                        return true;
                    }
                });
            }

            public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
                converters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter(statsBaseUrl, statsClientId, statsScope, statsRedirectUri));
            }
        };
    }

    @Bean
    @Profile(value={"!dev"})
    public Csa csaClient(@Value(value="${csa.base.url}") String csaBaseLocation, @Value(value="${csa.client.key}") String clientKey, @Value(value="${csa.client.secret}") String clientSecret, @Value(value="${csa.oauth2.accessTokenUrl}") String accessTokenUrl) {
        return new CsaImpl(accessTokenUrl, clientKey, clientSecret, "actions cross-idp-services stats", csaBaseLocation);
    }

    @Bean
    @Profile(value={"dev"})
    public Csa csaMockClient() {
        return new CsaMock();
    }

    @Bean
    @Profile(value={"!dev"})
    public Sab sab(HttpClientTransport httpClientTransport) {
        return new SabClient(httpClientTransport);
    }

    @Bean
    @Profile(value={"dev"})
    public Sab sabMock() {
        return new SabClientMock();
    }

    @Bean
    @Profile(value={"!dev"})
    public VootClient vootClient(Environment environment, @Value(value="${voot.accessTokenUri}") String accessTokenUri, @Value(value="${voot.clientId}") String clientId, @Value(value="${voot.clientSecret}") String clientSecret, @Value(value="${voot.scopes}") String spaceDelimitedScopes, @Value(value="${voot.serviceUrl}") String serviceUrl) {
        return new VootClientImpl(accessTokenUri, clientId, clientSecret, spaceDelimitedScopes, serviceUrl);
    }

    @Bean
    @Profile(value={"dev"})
    public VootClient mockVootClient(Environment environment) {
        return new VootClientMock();
    }

    @Bean
    public EmbeddedServletContainerCustomizer containerCustomizer() {
        return new ErrorCustomizer();
    }

    private static class ErrorCustomizer
    implements EmbeddedServletContainerCustomizer {
        private ErrorCustomizer() {
        }

        public void customize(ConfigurableEmbeddedServletContainer container) {
            container.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.FORBIDDEN, "/forbidden")});
        }
    }
}

